/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class PackageTypeSearcher {
    private String packageName;
    private String remainder;
    private String fullString;
    private ResultFilter filter;

    public PackageTypeSearcher(String string) {
        this.fullString = string;
        int lastDot = string.lastIndexOf(".");
        if (lastDot == -1) {
            this.packageName = string;
            this.remainder = null;
        } else {
            this.packageName = string.substring(0, lastDot);
            this.remainder = string.substring(lastDot + 1);
        }
    }

    public PackageTypeSearcher(String string, ResultFilter filter) {
        this(string);
        this.filter = filter;
    }

    public ArrayList getPackageProposals() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchPattern packagePattern = SearchPattern.createPattern((String)this.fullString, (int)2, (int)0, (int)1);
        if (packagePattern == null) {
            return new ArrayList();
        }
        SearchEngine searchEngine = new SearchEngine();
        LocalTextfieldSearchRequestor requestor = new LocalTextfieldSearchRequestor();
        try {
            searchEngine.search(packagePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            ArrayList results = requestor.getResults();
            Collections.sort(results, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof IPackageFragment)) {
                        return 0;
                    }
                    if (!(o2 instanceof IPackageFragment)) {
                        return 0;
                    }
                    IPackageFragment o1a = (IPackageFragment)o1;
                    IPackageFragment o2a = (IPackageFragment)o2;
                    return o1a.getElementName().compareTo(o2a.getElementName());
                }
            });
            return results;
        }
        catch (CoreException coreException) {
            return new ArrayList();
        }
    }

    public IPackageFragment getPackage() {
        ArrayList results;
        block4: {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            SearchPattern packagePattern = SearchPattern.createPattern((String)this.packageName, (int)2, (int)0, (int)0);
            if (packagePattern == null) {
                return null;
            }
            SearchEngine searchEngine = new SearchEngine();
            LocalTextfieldSearchRequestor requestor = new LocalTextfieldSearchRequestor();
            try {
                searchEngine.search(packagePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                results = requestor.getResults();
                if (results.size() == 1) break block4;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return (IPackageFragment)results.get(0);
    }

    public ArrayList getTypeMatches() {
        IPackageFragment packageElement = this.getPackage();
        if (packageElement != null && this.remainder != null) {
            try {
                IClassFile[] classFiles = packageElement.getClassFiles();
                ICompilationUnit[] compUnits = packageElement.getCompilationUnits();
                ArrayList<IType> returnList = new ArrayList<IType>();
                int i = 0;
                while (i < classFiles.length) {
                    String typeName = classFiles[i].getType().getElementName();
                    if (!typeName.equals("") && typeName.toLowerCase().startsWith(this.remainder.toLowerCase()) && (this.filter == null || this.filter.accept(classFiles[i].getType()))) {
                        returnList.add(classFiles[i].getType());
                    }
                    ++i;
                }
                i = 0;
                while (i < compUnits.length) {
                    IType type = compUnits[i].findPrimaryType();
                    String typeName = type.getElementName();
                    if (typeName.toLowerCase().startsWith(this.remainder.toLowerCase()) && (this.filter == null || this.filter.accept(type))) {
                        returnList.add(type);
                    }
                    ++i;
                }
                return returnList;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    public ICompletionProposal[] generateProposals(int beginIndex) {
        return this.generateProposals(beginIndex, "", "");
    }

    public ICompletionProposal[] generateProposals(int beginIndex, String proposalPrefix, String proposalSuffix) {
        CompletionProposal p;
        String replaceString;
        ArrayList packages = this.getPackageProposals();
        ArrayList types = this.getTypeMatches();
        JavaUILabelProvider imageDelegate = new JavaUILabelProvider();
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
        for (IType type : types) {
            replaceString = String.valueOf(proposalPrefix) + type.getFullyQualifiedName() + proposalSuffix;
            p = new CompletionProposal(replaceString, beginIndex, this.fullString.length(), replaceString.length(), imageDelegate.getImage((Object)type), type.getElementName(), null, null);
            list.add(p);
        }
        for (IPackageFragment fragment : packages) {
            replaceString = String.valueOf(proposalPrefix) + fragment.getElementName() + proposalSuffix;
            p = new CompletionProposal(replaceString, beginIndex, this.fullString.length(), replaceString.length(), imageDelegate.getImage((Object)fragment), null, null, null);
            list.add(p);
        }
        ICompletionProposal[] props = new ICompletionProposal[list.size()];
        list.toArray(props);
        return props;
    }

    private class LocalTextfieldSearchRequestor
    extends SearchRequestor {
        private ArrayList results = new ArrayList();

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (PackageTypeSearcher.this.filter == null || PackageTypeSearcher.this.filter.accept(match.getElement())) {
                this.results.add(match.getElement());
            }
        }

        public void beginReporting() {
            super.beginReporting();
        }

        public void endReporting() {
        }

        public ArrayList getResults() {
            return this.results;
        }
    }

    public static interface ResultFilter {
        public boolean accept(Object var1);
    }
}

