/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModule2;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.ServerUICore;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentPage;
import org.jboss.ide.eclipse.as.ui.editor.internal.ChangeModuleDeploymentPropertyCommand;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.server.controllable.systems.AbstractJBossDeploymentOptionsController;

public class ModuleDeploymentOptionsComposite
extends Composite
implements PropertyChangeListener {
    protected static final String ALL = Messages.EditorDeploymentPageFilterAll;
    protected static final String DEPLOYABLE = Messages.EditorDeploymentPageFilterDeployable;
    protected static final String DEPLOYED = Messages.EditorDeploymentPageFilterDeployed;
    protected static final String COLUMN_NAME = "name";
    protected static final String COLUMN_ZIP = "zip";
    protected static final String COLUMN_LOC = "location";
    protected static final String COLUMN_TEMP_LOC = "tempLocation";
    protected static final String OUTPUT_NAME = "outputName";
    protected static final String MAIN = "local";
    private static String[] ZIP_STRINGS = new String[]{"Default", "Yes", "No"};
    private DeploymentPreferences preferences;
    private TreeViewer viewer;
    private Combo filterCombo;
    private Text filterText;
    private Button refreshLink;
    private DeploymentPage partner;
    private IServerWorkingCopy lastWC;
    protected ArrayList<IModule> possibleModules;
    private FormToolkit tk;

    public ModuleDeploymentOptionsComposite(Composite parent, DeploymentPage partner, FormToolkit tk, DeploymentPreferences prefs) {
        super(parent, 0);
        this.partner = partner;
        this.preferences = prefs;
        this.lastWC = partner.getServer();
        this.lastWC.addPropertyChangeListener((PropertyChangeListener)this);
        this.tk = tk;
        this.refreshPossibleModules();
        this.createViewerPortion(this);
    }

    public void dispose() {
        this.lastWC.removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected Composite createViewerPortion(Composite root) {
        this.setLayout((Layout)new FormLayout());
        this.tk.adapt(root);
        Composite filterComposite = this.createFilterComposite(root);
        this.viewer = this.createTreeViewer(root);
        if (filterComposite == null) {
            FormData treeData = FormDataUtility.createFormData2((Object)0, (int)5, null, (int)-5, (Object)0, (int)5, (Object)100, (int)-5);
            this.viewer.getTree().setLayoutData((Object)treeData);
        } else {
            FormData filterData = FormDataUtility.createFormData2((Object)0, (int)5, (Object)this.viewer.getTree(), (int)-5, (Object)0, (int)5, (Object)100, (int)-5);
            filterComposite.setLayoutData((Object)filterData);
            FormData treeData = FormDataUtility.createFormData2((Object)filterComposite, (int)10, (Object)100, (int)-5, (Object)0, (int)5, (Object)100, (int)-5);
            this.viewer.getTree().setLayoutData((Object)treeData);
        }
        return root;
    }

    protected Composite createFilterComposite(Composite root) {
        Composite wrapper = new Composite(root, 0);
        wrapper.setLayout((Layout)new GridLayout(20, true));
        this.tk.adapt(wrapper);
        Composite wrapper1 = new Composite(wrapper, 0);
        wrapper1.setLayout((Layout)new GridLayout(3, true));
        this.tk.adapt(wrapper1);
        Label comboLabel = new Label(wrapper1, 0);
        comboLabel.setText(Messages.EditorDeploymentPageFilterBy);
        this.filterCombo = new Combo(wrapper1, 8);
        this.filterCombo.setItems(this.getViewerFilterTypes());
        this.filterCombo.select(0);
        this.filterText = new Text(wrapper, 2052);
        this.refreshLink = new Button(wrapper, 8);
        this.refreshLink.setText(Messages.EditorRefreshViewer);
        comboLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).create());
        this.filterCombo.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).create());
        wrapper1.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(5, 1).grab(true, false).create());
        this.filterText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(12, 1).grab(true, false).create());
        this.refreshLink.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).create());
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleDeploymentOptionsComposite.this.refreshPossibleModules();
                ModuleDeploymentOptionsComposite.this.resetFilterTextState();
                ModuleDeploymentOptionsComposite.this.viewer.setInput((Object)"");
            }
        };
        this.filterCombo.addModifyListener(ml);
        this.filterText.addModifyListener(ml);
        this.refreshLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ModuleDeploymentOptionsComposite.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return wrapper;
    }

    protected TreeViewer createTreeViewer(Composite root) {
        TreeViewer viewer = new TreeViewer(root, 2048);
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)this.createViewerContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.createViewerLabelProvider());
        ArrayList<String> columnIDs = new ArrayList<String>();
        ArrayList<Object> cellEditors = new ArrayList<Object>();
        TreeColumn moduleColumn = new TreeColumn(viewer.getTree(), 0);
        moduleColumn.setText(Messages.EditorModule);
        moduleColumn.setWidth(200);
        columnIDs.add(COLUMN_NAME);
        cellEditors.add(new TextCellEditor((Composite)viewer.getTree()));
        boolean showZip = this.showZipColumn();
        TreeColumn moduleZip = null;
        if (showZip) {
            moduleZip = new TreeColumn(viewer.getTree(), 0);
            moduleZip.setText("Zip Module");
            moduleZip.setWidth(100);
            columnIDs.add(COLUMN_ZIP);
            cellEditors.add(new ComboBoxCellEditor((Composite)viewer.getTree(), ZIP_STRINGS, 8));
        }
        TreeColumn publishLocColumn = new TreeColumn(viewer.getTree(), 0);
        publishLocColumn.setText(Messages.EditorSetDeployLabel);
        publishLocColumn.setWidth(200);
        columnIDs.add(COLUMN_LOC);
        cellEditors.add(new TextCellEditor((Composite)viewer.getTree()));
        boolean showTemp = this.showTemporaryColumn();
        TreeColumn publishTempLocColumn = null;
        if (showTemp) {
            publishTempLocColumn = new TreeColumn(viewer.getTree(), 0);
            publishTempLocColumn.setText(Messages.EditorSetTempDeployLabel);
            publishTempLocColumn.setWidth(200);
            columnIDs.add(COLUMN_TEMP_LOC);
            cellEditors.add(new TextCellEditor((Composite)viewer.getTree()));
        }
        String[] colNames = columnIDs.toArray(new String[columnIDs.size()]);
        CellEditor[] editors = cellEditors.toArray(new CellEditor[cellEditors.size()]);
        viewer.setColumnProperties(colNames);
        viewer.setInput((Object)"");
        viewer.setCellEditors(editors);
        viewer.setCellModifier(this.createViewerCellModifier());
        return viewer;
    }

    protected boolean showTemporaryColumn() {
        return true;
    }

    protected boolean showZipColumn() {
        return true;
    }

    protected ITableLabelProvider createViewerLabelProvider() {
        return new ModulePageLabelProvider();
    }

    protected ITreeContentProvider createViewerContentProvider() {
        return new ModulePageContentProvider();
    }

    protected ICellModifier createViewerCellModifier() {
        return new ModuleDeploymentCellModifier(this);
    }

    protected String[] getViewerFilterTypes() {
        return new String[]{ALL, DEPLOYABLE, DEPLOYED};
    }

    public void resetFilterTextState() {
        int ind = this.filterCombo.getSelectionIndex();
        boolean enabled = ind != -1 && this.usesViewerFilterText(this.filterCombo.getItem(ind));
        this.filterText.setEnabled(enabled);
    }

    protected boolean usesViewerFilterText(String comboItem) {
        return true;
    }

    public void refreshViewer() {
        this.refreshPossibleModules();
        this.viewer.setInput((Object)"");
    }

    protected void refreshPossibleModules() {
        ArrayList<IModule> possibleChildren = new ArrayList<IModule>();
        IModule[] modules2 = ServerUtil.getModules((IModuleType[])this.partner.getServer().getServerType().getRuntimeType().getModuleTypes());
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IModule module = modules2[i];
                IStatus status = this.partner.getServer().canModifyModules(new IModule[]{module}, null, null);
                if (status != null && status.getSeverity() != 4) {
                    possibleChildren.add(module);
                }
                ++i;
            }
        }
        this.possibleModules = possibleChildren;
    }

    public IModule[] getPossibleModules() {
        return this.possibleModules.toArray(new IModule[this.possibleModules.size()]);
    }

    protected DeploymentPreferences getPreferences() {
        return this.preferences;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public void firePropertyChangeCommand(DeploymentModulePrefs p, String[] keys, String[] vals, String cmdName) {
        this.partner.execute((IUndoableOperation)new ChangeModuleDeploymentPropertyCommand(this.partner, this.preferences, p, keys, vals, cmdName, (Viewer)this.viewer));
    }

    protected Object[] getFilteredModules() {
        String txt;
        Object[] mods = this.getPossibleModules();
        if (this.filterCombo == null) {
            return mods;
        }
        String item = this.filterCombo.getItem(this.filterCombo.getSelectionIndex());
        if (item.equals(DEPLOYED)) {
            mods = this.partner.getHelper().getServer().getModules();
        } else if (item.equals(DEPLOYABLE)) {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < mods.length) {
                try {
                    IModule[] parent = this.partner.getServer().getRootModules((IModule)mods[i], (IProgressMonitor)new NullProgressMonitor());
                    if (parent.length == 1 && parent[0] == mods[i]) {
                        result.add(mods[i]);
                    }
                }
                catch (CoreException parent) {
                    // empty catch block
                }
                ++i;
            }
            mods = result.toArray(new IModule[result.size()]);
        }
        if (this.filterText != null && !(txt = this.filterText.getText()).isEmpty()) {
            ArrayList<Object> collector = new ArrayList<Object>(Arrays.asList(mods));
            Iterator<Object> it = collector.iterator();
            while (it.hasNext()) {
                IModule t = (IModule)it.next();
                if (t.getName().toLowerCase().contains(txt.toLowerCase())) continue;
                it.remove();
            }
            return collector.toArray(new IModule[collector.size()]);
        }
        return mods;
    }

    public void updateListeners() {
        if (this.lastWC != null) {
            this.lastWC.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.lastWC = this.partner.getServer();
        if (this.lastWC != null) {
            this.lastWC.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference".equals(evt.getPropertyName())) {
            this.viewer.refresh();
        }
    }

    protected String getDefaultOutputName(IModule module) {
        String suffix;
        String lastSegment;
        String tmpName = null;
        if (module instanceof IModule2) {
            tmpName = ((IModule2)module).getProperty("org.eclipse.wst.server.core.deployName");
        }
        if (tmpName == null) {
            tmpName = module.getName();
        }
        String ret = (lastSegment = new Path(tmpName).lastSegment()).endsWith(suffix = PublishUtil.getSuffix((String)module.getModuleType().getId())) ? lastSegment : String.valueOf(lastSegment) + suffix;
        return ret;
    }

    protected String getOutputFolderAndName(DeploymentModulePrefs modPref, IModule m) {
        String folder = modPref.getProperty(COLUMN_LOC);
        String outputName = modPref.getProperty(OUTPUT_NAME);
        String string = outputName = outputName == null || outputName.length() == 0 ? this.getDefaultOutputName(m) : outputName;
        if (folder != null) {
            return new Path(folder).append(outputName).toPortableString();
        }
        return outputName;
    }

    public IStatus[] validate() {
        return new IStatus[0];
    }

    public Control[] getEnablementImmuneWidgets() {
        return new Control[]{this.filterCombo, this.filterText, this.refreshLink};
    }

    protected static class ModuleDeploymentCellModifier
    implements ICellModifier {
        private ModuleDeploymentOptionsComposite composite;

        public ModuleDeploymentCellModifier(ModuleDeploymentOptionsComposite composite) {
            this.composite = composite;
        }

        protected ModuleDeploymentOptionsComposite getComposite() {
            return this.composite;
        }

        protected DeploymentPreferences getPreferences() {
            return this.composite.getPreferences();
        }

        protected TreeViewer getViewer() {
            return this.composite.getViewer();
        }

        public boolean canModify(Object element, String property) {
            return property != ModuleDeploymentOptionsComposite.COLUMN_NAME;
        }

        public Object getValue(Object element, String property) {
            DeploymentModulePrefs p = this.getPreferences().getOrCreatePreferences().getOrCreateModulePrefs((IModule)element);
            if (property == ModuleDeploymentOptionsComposite.COLUMN_LOC) {
                return this.composite.getOutputFolderAndName(p, (IModule)element);
            }
            if (property == ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC) {
                String ret = p.getProperty(ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC);
                return ret == null ? "" : ret;
            }
            if (property == ModuleDeploymentOptionsComposite.COLUMN_ZIP) {
                String ret = p.getProperty(ModuleDeploymentOptionsComposite.COLUMN_ZIP);
                try {
                    return Integer.valueOf(ret);
                }
                catch (NumberFormatException numberFormatException) {
                    return AbstractJBossDeploymentOptionsController.ZIP_DEFAULT;
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            IModule module = (IModule)((TreeItem)element).getData();
            DeploymentModulePrefs p = this.getPreferences().getOrCreatePreferences().getOrCreateModulePrefs(module);
            if (property == ModuleDeploymentOptionsComposite.COLUMN_LOC) {
                String outPath;
                String outputName;
                if (value == null || ((String)value).equals("")) {
                    outputName = "";
                    outPath = "";
                } else {
                    outputName = new Path((String)value).lastSegment();
                    outPath = ((String)value).substring(0, ((String)value).length() - outputName.length());
                }
                this.getComposite().firePropertyChangeCommand(p, new String[]{ModuleDeploymentOptionsComposite.COLUMN_LOC, ModuleDeploymentOptionsComposite.OUTPUT_NAME}, new String[]{outPath, outputName}, Messages.EditorEditDeployLocCommand);
                this.getComposite().getViewer().refresh();
            } else if (property == ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC) {
                this.getComposite().firePropertyChangeCommand(p, new String[]{ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC}, new String[]{(String)value}, Messages.EditorEditDeployLocCommand);
                this.getComposite().getViewer().refresh();
            } else if (property == ModuleDeploymentOptionsComposite.COLUMN_ZIP) {
                this.getComposite().firePropertyChangeCommand(p, new String[]{ModuleDeploymentOptionsComposite.COLUMN_ZIP}, new String[]{value.toString()}, "Edit Deployment Zipped");
                this.getComposite().getViewer().refresh();
            }
        }
    }

    private class ModulePageContentProvider
    implements ITreeContentProvider {
        private ModulePageContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ModuleDeploymentOptionsComposite.this.getFilteredModules();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }

    private class ModulePageLabelProvider
    implements ITableLabelProvider {
        private ModulePageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IModule && columnIndex == 0) {
                ILabelProvider labelProvider = ServerUICore.getLabelProvider();
                Image image = labelProvider.getImage((Object)((IModule)element));
                labelProvider.dispose();
                return image;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IModule) {
                int tempLocIndex = -1;
                int zipIndex = -1;
                int moduleIndex = 0;
                zipIndex = ModuleDeploymentOptionsComposite.this.showZipColumn() ? 1 : -1;
                int locIndex = zipIndex == -1 ? moduleIndex + 1 : zipIndex + 1;
                tempLocIndex = ModuleDeploymentOptionsComposite.this.showTemporaryColumn() ? locIndex + 1 : -1;
                IModule m = (IModule)element;
                if (columnIndex == moduleIndex) {
                    return m.getName();
                }
                DeploymentModulePrefs modPref = ModuleDeploymentOptionsComposite.this.preferences.getOrCreatePreferences().getOrCreateModulePrefs(m);
                if (columnIndex == zipIndex) {
                    String ret = modPref.getProperty(ModuleDeploymentOptionsComposite.COLUMN_ZIP);
                    int retInd = 0;
                    if (ret != null) {
                        try {
                            retInd = Integer.parseInt(ret);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (retInd > 2 || retInd < 0) {
                        retInd = 0;
                    }
                    return ZIP_STRINGS[retInd];
                }
                if (columnIndex == locIndex) {
                    return ModuleDeploymentOptionsComposite.this.getOutputFolderAndName(modPref, m);
                }
                if (columnIndex == tempLocIndex) {
                    String result = modPref.getProperty(ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC);
                    if (result != null) {
                        return result;
                    }
                    modPref.setProperty(ModuleDeploymentOptionsComposite.COLUMN_TEMP_LOC, "");
                    return "";
                }
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

