/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class PollerSection
extends ServerEditorSection
implements PropertyChangeListener {
    private Combo startPollerCombo;
    private Combo stopPollerCombo;
    private Composite pollers;
    private String[] startupTypesStrings;
    private String[] shutdownTypesStrings;
    private IServerStatePollerType[] startupTypes;
    private IServerStatePollerType[] shutdownTypes;
    private ModifyListener startPollerListener;
    private ModifyListener stopPollerListener;
    protected ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
        this.server.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.findPossiblePollers();
        this.createUI(parent);
        this.addListeners();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.PollerSection_ServerPollingSection);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        this.pollers = toolkit.createComposite(composite);
        this.pollers.setLayout((Layout)new GridLayout(2, false));
        Label start = new Label(this.pollers, 0);
        this.startPollerCombo = new Combo(this.pollers, 8);
        Label stop = new Label(this.pollers, 0);
        this.stopPollerCombo = new Combo(this.pollers, 8);
        start.setText(Messages.EditorStartupPollerLabel);
        stop.setText(Messages.EditorShutdownPollerLabel);
        this.startPollerCombo.setItems(this.startupTypesStrings);
        this.stopPollerCombo.setItems(this.shutdownTypesStrings);
        this.startPollerCombo.setEnabled(true);
        this.stopPollerCombo.setEnabled(true);
        String currentStartId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.WebPoller");
        String currentStopId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller");
        int startIndex = this.startPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStartId).getName());
        int stopIndex = this.stopPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStopId).getName());
        if (startIndex >= 0) {
            this.startPollerCombo.select(startIndex);
        }
        if (stopIndex >= 0) {
            this.stopPollerCombo.select(stopIndex);
        }
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    protected void refreshUI() {
        this.startPollerCombo.removeModifyListener(this.startPollerListener);
        this.stopPollerCombo.removeModifyListener(this.stopPollerListener);
        this.findPossiblePollers();
        this.startPollerCombo.setItems(this.startupTypesStrings);
        this.stopPollerCombo.setItems(this.shutdownTypesStrings);
        String currentStartId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.WebPoller");
        String currentStopId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller");
        int startIndex = this.startPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStartId).getName());
        int stopIndex = this.stopPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStopId).getName());
        if (startIndex >= 0) {
            this.startPollerCombo.select(startIndex);
        }
        if (stopIndex >= 0) {
            this.stopPollerCombo.select(stopIndex);
        }
        this.startPollerCombo.addModifyListener(this.startPollerListener);
        this.stopPollerCombo.addModifyListener(this.stopPollerListener);
    }

    protected void findPossiblePollers() {
        String currentMode = ServerProfileModel.getProfile((IServerAttributes)this.server);
        this.startupTypes = ExtensionManager.getDefault().getStartupPollers(this.server.getServerType(), currentMode);
        this.shutdownTypes = ExtensionManager.getDefault().getShutdownPollers(this.server.getServerType(), currentMode);
        this.startupTypesStrings = new String[this.startupTypes.length];
        this.shutdownTypesStrings = new String[this.shutdownTypes.length];
        int i = 0;
        while (i < this.startupTypes.length) {
            this.startupTypesStrings[i] = this.startupTypes[i].getName();
            ++i;
        }
        i = 0;
        while (i < this.shutdownTypes.length) {
            this.shutdownTypesStrings[i] = this.shutdownTypes[i].getName();
            ++i;
        }
    }

    protected void addListeners() {
        this.startPollerListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PollerSection.this.startPollerCombo.getSelectionIndex() != -1) {
                    PollerSection.this.execute((IUndoableOperation)new SetStartupPollerCommand(PollerSection.this.server));
                }
            }
        };
        this.stopPollerListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PollerSection.this.stopPollerCombo.getSelectionIndex() != -1) {
                    PollerSection.this.execute((IUndoableOperation)new SetStopPollerCommand(PollerSection.this.server));
                }
            }
        };
        this.startPollerCombo.addModifyListener(this.startPollerListener);
        this.stopPollerCombo.addModifyListener(this.stopPollerListener);
    }

    public void dispose() {
        this.server.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (ServerProfileModel.isProfileKey((String)propertyName)) {
            this.refreshUI();
        }
    }

    public IStatus[] getSaveStatus() {
        IStatus s = Status.OK_STATUS;
        if (!LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)this.server)) {
            if (this.startPollerCombo.getSelectionIndex() == -1) {
                s = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.EditorStartupPollerNotSet);
            }
            if (this.stopPollerCombo.getSelectionIndex() == -1) {
                s = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.EditorShutdownPollerNotSet);
            }
        }
        return new IStatus[]{s};
    }

    public class SetPollerCommand
    extends ServerCommand {
        private String preChange;
        private String attributeKey;
        private String defaultValue;
        private IServerStatePollerType[] pollerArray;
        private Combo combo;
        private ModifyListener listener;

        public SetPollerCommand(IServerWorkingCopy server, String name, String attributeKey, String defaultValue, IServerStatePollerType[] pollerArray, Combo pollerCombo, ModifyListener listener) {
            super(server, name);
            this.attributeKey = attributeKey;
            this.defaultValue = defaultValue;
            this.pollerArray = pollerArray;
            this.combo = pollerCombo;
            this.listener = listener;
        }

        public void execute() {
            this.preChange = PollerSection.this.helper.getAttribute(this.attributeKey, this.defaultValue);
            PollerSection.this.helper.setAttribute(this.attributeKey, this.pollerArray[this.combo.getSelectionIndex()].getId());
        }

        public void undo() {
            PollerSection.this.helper.setAttribute(this.attributeKey, this.preChange);
            this.combo.removeModifyListener(this.listener);
            int ind = this.findIndex(this.preChange);
            if (ind == -1) {
                this.combo.clearSelection();
            } else {
                this.combo.select(ind);
            }
            this.combo.addModifyListener(this.listener);
        }

        protected int findIndex(String id) {
            int i = 0;
            while (i < this.pollerArray.length) {
                if (this.pollerArray[i].getId().equals(id)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public class SetStartupPollerCommand
    extends SetPollerCommand {
        public SetStartupPollerCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeStartPollerCommandName, "org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.WebPoller", PollerSection.this.startupTypes, PollerSection.this.startPollerCombo, PollerSection.this.startPollerListener);
        }
    }

    public class SetStopPollerCommand
    extends SetPollerCommand {
        public SetStopPollerCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeStopPollerCommandName, "org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller", PollerSection.this.shutdownTypes, PollerSection.this.stopPollerCombo, PollerSection.this.stopPollerListener);
        }
    }
}

