/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.tools.as.wst.server.ui.xpl.ServerToolTip;

public class XPathTreeContentProvider
implements ITreeContentProvider {
    public static final DelayProxy LOADING = new DelayProxy();
    private Viewer viewer;
    private ArrayList<XPathCategory> loading = new ArrayList();
    private ServerToolTip tooltip = null;

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return new Object[0];
        }
        if (parentElement instanceof IServer) {
            ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)((IServer)parentElement));
            if (props == null || !props.allowConvenienceEnhancements()) {
                return new Object[0];
            }
            return new Object[]{new ServerWrapper((IServer)parentElement)};
        }
        if (parentElement instanceof ServerWrapper) {
            return XPathModel.getDefault().getCategories(((ServerWrapper)parentElement).server);
        }
        if (parentElement instanceof XPathCategory) {
            if (((XPathCategory)parentElement).isLoaded()) {
                return ((XPathCategory)parentElement).getQueries();
            }
            if (!this.loading.contains((XPathCategory)parentElement)) {
                this.launchLoad((XPathCategory)parentElement);
            }
            return new Object[]{LOADING};
        }
        if (parentElement instanceof XPathQuery) {
            if (XPathModel.getResultNodes((XPathQuery)((XPathQuery)parentElement)).length == 1) {
                return new Object[0];
            }
            return ((XPathQuery)parentElement).getResults();
        }
        if (parentElement instanceof XPathFileResult) {
            if (((XPathFileResult)parentElement).getChildren().length == 1) {
                return new Object[0];
            }
            return ((XPathFileResult)parentElement).getChildren();
        }
        if (parentElement instanceof XPathFileResult.XPathResultNode) {
            return new Object[0];
        }
        return new Object[0];
    }

    protected void launchLoad(final XPathCategory cat) {
        new Job(Messages.XPathTreeContentProvider_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                XPathTreeContentProvider.this.loading.add(cat);
                XPathQuery[] queries = cat.getQueries();
                int i = 0;
                while (i < queries.length) {
                    XPathFileResult[] results = queries[i].getResults();
                    int j = 0;
                    while (j < results.length) {
                        results[j].getChildren();
                        ++j;
                    }
                    ++i;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XPathTreeContentProvider.this.loading.remove(cat);
                        ((StructuredViewer)XPathTreeContentProvider.this.viewer).refresh((Object)cat.getServer());
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule(200L);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.tooltip != null) {
            this.tooltip.deactivate();
        }
        this.viewer = viewer;
        this.tooltip = new ServerToolTip(((TreeViewer)viewer).getTree()){

            @Override
            protected boolean isMyType(Object selected) {
                return selected instanceof ServerWrapper;
            }

            @Override
            protected void fillStyledText(Composite parent, StyledText sText, Object o) {
                sText.setText("Quickly modify xpath values in your server installation.");
            }
        };
        this.tooltip.setShift(new Point(15, 8));
        this.tooltip.setPopupDelay(500);
        this.tooltip.setHideOnMouseDown(true);
        this.tooltip.activate();
    }

    public static class DelayProxy {
    }

    public class ServerWrapper {
        public IServer server;

        public ServerWrapper(IServer server) {
            this.server = server;
        }

        public int hashCode() {
            return this.server.getId().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ServerWrapper && ((ServerWrapper)other).server.getId().equals(this.server.getId());
        }
    }
}

