/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.LocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.ui.wizards.ServerProfileWizardFragment;

public class LegacyServerProfileWizardFragment
extends ServerProfileWizardFragment {
    private RuntimeDetailsComposite rtDetails;

    @Override
    protected void addRuntimeDetailsGroup(Composite parent) {
        Group g = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 500;
        g.setLayoutData((Object)gd);
        g.setLayout((Layout)new GridLayout(1, true));
        this.rtDetails = new RuntimeDetailsComposite((Composite)g, 0);
        g.setText("Runtime Details");
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        this.rtDetails.update(rt);
    }

    @Override
    protected void runtimeComboChanged() {
        super.runtimeComboChanged();
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        if (this.rtDetails != null && !this.rtDetails.isDisposed()) {
            this.rtDetails.update(rt);
        }
    }

    private class RuntimeDetailsComposite
    extends Composite {
        private Label jreVal;
        private Label homedirVal;
        private Label basedirVal;
        private Label configVal;

        RuntimeDetailsComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(2, false));
            Label jre = new Label((Composite)this, 0);
            jre.setText("JRE: ");
            this.jreVal = new Label((Composite)this, 0);
            Label homedir = new Label((Composite)this, 0);
            homedir.setText("Home Directory: ");
            this.homedirVal = new Label((Composite)this, 0);
            Label basedir = new Label((Composite)this, 0);
            basedir.setText("Base Directory: ");
            this.basedirVal = new Label((Composite)this, 0);
            Label config = new Label((Composite)this, 0);
            config.setText("Configuration File: ");
            this.configVal = new Label((Composite)this, 0);
        }

        public void update(IRuntime rt) {
            LocalJBossServerRuntime jbsrt;
            LocalJBossServerRuntime localJBossServerRuntime = jbsrt = rt == null ? null : (LocalJBossServerRuntime)rt.loadAdapter(LocalJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (!this.jreVal.isDisposed()) {
                if (jbsrt != null) {
                    this.jreVal.setText(jbsrt.getVM().getInstallLocation().getAbsolutePath());
                    this.homedirVal.setText(rt.getLocation().toOSString());
                    this.basedirVal.setText(jbsrt.getConfigLocation());
                    this.configVal.setText(jbsrt.getJBossConfiguration());
                } else {
                    this.jreVal.setText("");
                    this.homedirVal.setText("");
                    this.basedirVal.setText("");
                    this.configVal.setText("");
                }
            }
        }
    }
}

