/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.runtimes.integration.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.tools.as.runtimes.integration.internal.RuntimeMatcherStringUtil;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class RuntimeMatcher {
    public String createPattern(String wtpId, String subType) {
        return this.createPattern(wtpId, subType, null, false, null, false);
    }

    public String createPattern(String wtpId, String subType, String beginVersion) {
        return this.createPattern(wtpId, subType, beginVersion, false, null, false);
    }

    public String createPattern(String wtpId, String otherType, String beginVersion, boolean bInclusive, String endVersion, boolean eInclusive) {
        return new RuntimeRangeRepresentation(wtpId, otherType, beginVersion, bInclusive, endVersion, eInclusive).toString();
    }

    public IRuntime[] findExistingRuntimes(String wtpId, String subType, String beginVersion, boolean bInclusive, String endVersion, boolean eInclusive) {
        RuntimeRangeRepresentation rep = new RuntimeRangeRepresentation(wtpId, subType, beginVersion, bInclusive, endVersion, eInclusive);
        return this.findExistingRuntimes(rep);
    }

    public IRuntime[] findExistingRuntimes(String pattern) {
        try {
            RuntimeRangeRepresentation rep = new RuntimeRangeRepresentation(pattern);
            return this.findExistingRuntimes(rep);
        }
        catch (IllegalArgumentException iae) {
            return new IRuntime[0];
        }
    }

    private IRuntime[] findExistingRuntimes(RuntimeRangeRepresentation rep) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] all = ServerCore.getRuntimes();
        int i = 0;
        while (i < all.length) {
            String rtType;
            if (all[i] != null && all[i].getRuntimeType() != null && (rtType = RuntimeUtils.getRuntimeTypeId((IRuntime)all[i])) != null && rtType.equals(rep.wtpId)) {
                if (rep.stacksRuntimeType == null) {
                    list.add(all[i]);
                } else {
                    ServerBeanLoader loader = new ServerBeanLoader(all[i].getLocation().toFile());
                    if (this.matchesServerBeanType(rep.stacksRuntimeType, loader)) {
                        if (rep.beginVersion == null) {
                            list.add(all[i]);
                        } else {
                            String version = loader.getFullServerVersion();
                            if (rep.matchesVersion(version)) {
                                list.add(all[i]);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return list.toArray(new IRuntime[list.size()]);
    }

    private boolean matchesServerBeanType(String stacksRuntimeType, ServerBeanLoader loader) {
        return stacksRuntimeType.equals(loader.getUnderlyingTypeId());
    }

    public DownloadRuntime[] findDownloadRuntimes(String wtpId, String subType, String beginVersion, boolean bInclusive, String endVersion, boolean eInclusive, IProgressMonitor monitor) {
        RuntimeRangeRepresentation rep = new RuntimeRangeRepresentation(wtpId, subType, beginVersion, bInclusive, endVersion, eInclusive);
        return this.findDownloadRuntimes(rep, monitor);
    }

    public DownloadRuntime[] findDownloadRuntimes(String pattern, IProgressMonitor monitor) {
        try {
            RuntimeRangeRepresentation rep = new RuntimeRangeRepresentation(pattern);
            return this.findDownloadRuntimes(rep, monitor);
        }
        catch (IllegalArgumentException iae) {
            return new DownloadRuntime[0];
        }
    }

    private DownloadRuntime[] findDownloadRuntimes(RuntimeRangeRepresentation rep, IProgressMonitor monitor) {
        monitor.beginTask("Locating Matching Downloadable Runtimes", 1000);
        DownloadRuntime[] arr = RuntimeCoreActivator.getDefault().getDownloadRuntimeArray((IProgressMonitor)new SubProgressMonitor(monitor, 800));
        SubProgressMonitor subMon = new SubProgressMonitor(monitor, 200);
        subMon.beginTask("Filtering Downloadable Runtimes", arr.length * 100);
        ArrayList<DownloadRuntime> list = new ArrayList<DownloadRuntime>(arr.length);
        int i = 0;
        while (i < arr.length) {
            String rtType = (String)arr[i].getProperty("wtp-runtime-type");
            if (rep.wtpId.equals(rtType)) {
                if (rep.stacksRuntimeType == null) {
                    list.add(arr[i]);
                } else if (rep.stacksRuntimeType.equals(arr[i].getProperty("runtime-type"))) {
                    if (rep.beginVersion == null) {
                        list.add(arr[i]);
                    } else {
                        String version = arr[i].getVersion();
                        if (rep.matchesVersion(version)) {
                            list.add(arr[i]);
                        }
                    }
                }
            }
            subMon.worked(100);
            ++i;
        }
        subMon.done();
        monitor.done();
        return list.toArray(new DownloadRuntime[list.size()]);
    }

    private static class RuntimeRangeRepresentation {
        private String wtpId;
        private String stacksRuntimeType;
        private String beginVersion;
        private String endVersion;
        private boolean bInclusive;
        private boolean eInclusive;
        private VersionRange osgiRange;

        public RuntimeRangeRepresentation(String wtpId, String subType, String beginVersion, boolean bInclusive, String endVersion, boolean eInclusive) {
            this.wtpId = wtpId;
            this.stacksRuntimeType = subType;
            this.beginVersion = beginVersion;
            this.endVersion = endVersion;
            this.bInclusive = bInclusive;
            this.eInclusive = eInclusive;
        }

        public RuntimeRangeRepresentation(String pattern) throws IllegalArgumentException {
            int openCurly = pattern.indexOf(123);
            this.wtpId = pattern;
            if (openCurly != -1) {
                if (pattern.charAt(pattern.length() - 1) != '}') {
                    throw new IllegalArgumentException();
                }
                this.wtpId = pattern.substring(0, openCurly);
                String remainder = pattern.substring(openCurly + 1, pattern.length() - 1);
                int colon = remainder.indexOf(58);
                if (colon == -1) {
                    this.stacksRuntimeType = remainder;
                } else {
                    this.stacksRuntimeType = remainder.substring(0, colon);
                    String versionRange = remainder.substring(colon + 1).trim();
                    char char0 = versionRange.charAt(0);
                    if (char0 == '[' || char0 == '(') {
                        this.bInclusive = char0 == '[';
                        char endChar = versionRange.charAt(versionRange.length() - 1);
                        if (endChar != ']' && endChar != ')') {
                            throw new IllegalArgumentException();
                        }
                        this.eInclusive = endChar == ']';
                        String range = versionRange.substring(1, versionRange.length() - 1);
                        String[] ranges = range.split(",");
                        this.beginVersion = ranges[0].trim();
                        this.endVersion = ranges[1].trim();
                    } else {
                        this.beginVersion = versionRange;
                        this.endVersion = null;
                    }
                    this.osgiRange = new VersionRange(versionRange);
                }
            }
        }

        public boolean matchesVersion(String version) {
            try {
                Version v = new Version(RuntimeMatcherStringUtil.getSafeVersionString(version));
                return this.osgiRange.includes(v);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.wtpId);
            if (this.stacksRuntimeType != null) {
                sb.append('{');
                sb.append(this.stacksRuntimeType);
                if (this.beginVersion != null) {
                    sb.append(":");
                    if (this.endVersion == null) {
                        sb.append(this.beginVersion);
                    } else {
                        sb.append(this.bInclusive ? (char)'[' : '(');
                        sb.append(this.beginVersion);
                        sb.append(',');
                        sb.append(this.endVersion);
                        sb.append(this.eInclusive ? (char)']' : ')');
                    }
                }
                sb.append('}');
            }
            return sb.toString();
        }
    }
}

