/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.participants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.participants.BatchParticipantMessages;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.refactoring.FileChangeFactory;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.BeanUtil;

public class BatchArtifactRenameParticipant
extends RenameParticipant {
    private IType type;
    private IField field;
    private String newName;
    private RefactoringStatus status;
    private CompositeChange rootChange;
    private TextFileChange lastChange;
    private ArrayList<String> keys = new ArrayList();

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.type = (IType)element;
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(BatchParticipantMessages.Updating_Batch_Artifacts_References);
            return true;
        }
        if (element instanceof IField) {
            this.field = (IField)element;
            this.type = this.field.getDeclaringType();
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(BatchParticipantMessages.Updating_Batch_Artifacts_References);
            return true;
        }
        return false;
    }

    public String getName() {
        return null;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        BatchProject[] projects;
        IProject project = this.type.getJavaProject().getProject();
        BatchProject batchProject = (BatchProject)BatchProjectFactory.getBatchProjectWithProgress((IProject)project);
        if (batchProject == null) {
            return this.status;
        }
        IBatchArtifact artifact = batchProject.getArtifact(this.type);
        IBatchProperty property = null;
        if (artifact != null) {
            if (this.field != null) {
                for (IBatchProperty prop : artifact.getProperties()) {
                    if (!prop.getField().equals(this.field)) continue;
                    IAnnotationDeclaration declaration = prop.getBatchPropertyDeclaration();
                    if (declaration == null || declaration.getMemberValue("name") != null) {
                        return this.status;
                    }
                    this.newName = this.getArguments().getNewName();
                    property = prop;
                }
            } else {
                IAnnotationDeclaration declaration = artifact.getNamedDeclaration();
                if (declaration == null || declaration.getMemberValue(null) != null) {
                    return this.status;
                }
                this.newName = BeanUtil.getDefaultBeanName((String)this.getArguments().getNewName());
            }
        } else {
            String fullyQualifiedName = this.type.getFullyQualifiedName();
            StringBuilder b = new StringBuilder(fullyQualifiedName);
            b.replace(fullyQualifiedName.lastIndexOf(this.type.getElementName()), fullyQualifiedName.lastIndexOf(this.type.getElementName()) + this.type.getElementName().length(), this.getArguments().getNewName());
            this.newName = b.toString();
        }
        this.searchInProject((IBatchProject)batchProject, artifact, property, pm);
        BatchProject[] batchProjectArray = projects = batchProject.getAllDependentProjects(true);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            BatchProject p = batchProjectArray[n2];
            this.searchInProject((IBatchProject)p, artifact, property, pm);
            ++n2;
        }
        return this.status;
    }

    private void searchInProject(IBatchProject batchProject, IBatchArtifact artifact, IBatchProperty property, IProgressMonitor monitor) {
        monitor.beginTask(BatchParticipantMessages.Searching_For_Batch_Artifacts_References, batchProject.getDeclaredBatchJobs().size());
        HashSet<ITextSourceReference> references = new HashSet<ITextSourceReference>();
        if (!batchProject.getProject().isSynchronized(0)) {
            Exception exception = new Exception(NLS.bind((String)BatchParticipantMessages.Cannot_Read_Out_Of_Sync_Resource, (Object)batchProject.getProject().getFullPath().toString()));
            exception.setStackTrace(Thread.currentThread().getStackTrace());
            BatchUIPlugin.getDefault().logError(exception);
            return;
        }
        if (artifact != null) {
            if (property != null) {
                references.addAll(this.searchForPropertyReferences(batchProject, artifact.getName(), property.getPropertyName(), monitor));
            } else {
                references.addAll(this.searchForReferences(batchProject, "ref", artifact.getName(), monitor));
            }
        } else {
            references.addAll(this.searchForReferences(batchProject, "class", this.type.getFullyQualifiedName(), monitor));
        }
        for (ITextSourceReference reference : references) {
            if (((IFile)reference.getResource()).isReadOnly()) {
                Exception exception = new Exception(NLS.bind((String)BatchParticipantMessages.Cannot_Change_Read_Only_File, (Object)((IFile)reference.getResource()).getFullPath().toString()));
                exception.setStackTrace(Thread.currentThread().getStackTrace());
                BatchUIPlugin.getDefault().logError(exception);
                continue;
            }
            this.change((IFile)reference.getResource(), reference.getStartPosition(), reference.getLength(), this.newName);
        }
        monitor.done();
    }

    private Collection<ITextSourceReference> searchForReferences(IBatchProject batchProject, String attributeName, String attributeValue, IProgressMonitor monitor) {
        int worked = 0;
        HashSet<ITextSourceReference> references = new HashSet<ITextSourceReference>();
        for (IFile file : batchProject.getDeclaredBatchJobs()) {
            if (monitor.isCanceled()) {
                return references;
            }
            if (file.isPhantom()) continue;
            if (!file.isSynchronized(0)) {
                Exception exception = new Exception(NLS.bind((String)BatchParticipantMessages.Cannot_Read_Out_Of_Sync_Resource, (Object)file.getFullPath().toString()));
                exception.setStackTrace(Thread.currentThread().getStackTrace());
                BatchUIPlugin.getDefault().logError(exception);
                return references;
            }
            references.addAll(BatchUtil.getAttributeReferences((IFile)file, (String)attributeName, (String)attributeValue));
            monitor.worked(++worked);
        }
        return references;
    }

    private Collection<ITextSourceReference> searchForPropertyReferences(IBatchProject batchProject, String artifactName, String propertyName, IProgressMonitor monitor) {
        int worked = 0;
        HashSet<ITextSourceReference> references = new HashSet<ITextSourceReference>();
        for (IFile file : batchProject.getDeclaredBatchJobs()) {
            if (monitor.isCanceled()) {
                return references;
            }
            if (file.isPhantom()) continue;
            if (!file.isSynchronized(0)) {
                Exception exception = new Exception(NLS.bind((String)BatchParticipantMessages.Cannot_Read_Out_Of_Sync_Resource, (Object)file.getFullPath().toString()));
                exception.setStackTrace(Thread.currentThread().getStackTrace());
                BatchUIPlugin.getDefault().logError(exception);
                return references;
            }
            references.addAll(BatchUtil.getPropertyAttributeReferences((IFile)file, (String)artifactName, (String)propertyName));
            monitor.worked(++worked);
        }
        return references;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = FileChangeFactory.getFileChange((IFile)file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rootChange.getChildren().length > 0) {
            return this.rootChange;
        }
        return null;
    }
}

