/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.eclipse.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.eclipse.Activator;
import org.jboss.tools.browsersim.eclipse.Messages;
import org.jboss.tools.browsersim.eclipse.launcher.ExternalProcessLauncher;
import org.jboss.tools.usage.internal.environment.eclipse.LinuxSystem;

public class PreferencesUtil {
    public static final String SEPARATOR = System.getProperty("file.separator");
    protected static final String JAVA_JVM_VERSION = "JAVA_JVM_VERSION";
    private static final String USER_PREFERENCES_FOLDER = "org.jboss.tools.browsersim";
    private static String configurationPath = null;

    public static List<IVMInstall> getSuitableJvms(int limit) {
        String eclipseOs = PlatformUtil.getOs();
        String eclipseArch = PlatformUtil.getArch();
        ArrayList<IVMInstall> vms = new ArrayList<IVMInstall>();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractVMInstall abstractVm;
                String javaVersion;
                IVMInstall vm = iVMInstallArray[n4];
                if (vm instanceof AbstractVMInstall && (javaVersion = (abstractVm = (AbstractVMInstall)vm).getJavaVersion()) != null && javaVersion.compareTo("1.7") >= 0) {
                    if ("win32".equals(eclipseOs)) {
                        String vmArch = PreferencesUtil.getArchitecture(vm);
                        if (eclipseArch.equals(vmArch) && !PreferencesUtil.conflictsWithWebKit((IVMInstall)abstractVm, vmArch)) {
                            vms.add((IVMInstall)abstractVm);
                        }
                    } else if (eclipseArch.equals(PreferencesUtil.getArchitecture(vm))) {
                        vms.add((IVMInstall)abstractVm);
                    }
                }
                if (limit > 0 && vms.size() >= limit) {
                    return vms;
                }
                ++n4;
            }
            ++n2;
        }
        return vms;
    }

    public static List<IVMInstall> getSuitableJvms() {
        return PreferencesUtil.getSuitableJvms(0);
    }

    public static IVMInstall getJVM(String id) {
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vm = iVMInstallArray[n4];
                if (id.equals(vm.getId())) {
                    return vm;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static String getArchitecture(IVMInstall defaultVMInstall) {
        String javaCommand = PreferencesUtil.getJavaCommand(defaultVMInstall);
        if (javaCommand != null) {
            try {
                return PreferencesUtil.generateLibraryInfo(defaultVMInstall.getInstallLocation(), javaCommand);
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private static boolean conflictsWithWebKit(IVMInstall vm, String vmArch) {
        if ("x86_64".equals(vmArch)) {
            return false;
        }
        File libxml2 = new File(String.valueOf(vm.getInstallLocation().getAbsolutePath()) + "/bin/libxml2.dll");
        return libxml2.exists();
    }

    public static String getJavaCommand(IVMInstall jvm) {
        File javaExecutable;
        File installLocation;
        if (jvm != null && (installLocation = jvm.getInstallLocation()) != null && (javaExecutable = StandardVMType.findJavaExecutable((File)installLocation)) != null) {
            return javaExecutable.getAbsolutePath();
        }
        return null;
    }

    public static String generateLibraryInfo(File javaHome, String javaCommand) throws IOException {
        String arch;
        block14: {
            arch = null;
            String currentBundleLocation = ExternalProcessLauncher.getBundleLocation(Platform.getBundle((String)"org.jboss.tools.browsersim.eclipse"));
            String[] cmdLine = new String[]{javaCommand, "-cp", currentBundleLocation, "org.jboss.tools.browsersim.eclipse.preferences.ArchitectureDetector"};
            Process p = null;
            try {
                try {
                    Map map;
                    String[] envp = null;
                    if ("macosx".equals(Platform.getOS()) && (map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved()).remove(JAVA_JVM_VERSION) != null) {
                        envp = new String[map.size()];
                        Iterator iterator = map.entrySet().iterator();
                        int i = 0;
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            envp[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                            ++i;
                        }
                    }
                    p = DebugPlugin.exec((String[])cmdLine, null, envp);
                    IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)Messages.BrowserSim_LIBRARY_DETECTION);
                    int i = 0;
                    while (i < 600) {
                        if (process.isTerminated()) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++i;
                    }
                    arch = PreferencesUtil.getArchitecture(process);
                }
                catch (CoreException ioe) {
                    LaunchingPlugin.log((Throwable)ioe);
                    if (p != null) {
                        p.destroy();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
            if (p != null) {
                p.destroy();
            }
        }
        if (arch == null) {
            LaunchingPlugin.log((String)NLS.bind((String)Messages.BrowserSim_LIBRARY_DETECTION_FAILURE, (Object[])new String[]{javaHome.getAbsolutePath()}));
        }
        return arch;
    }

    public static String getAbsolutePathToConfigurationFolder() throws URISyntaxException, IOException {
        URL url;
        URI resolvedURI;
        File file;
        if (configurationPath == null && (file = new File(resolvedURI = new URI((url = FileLocator.toFileURL((URL)Platform.getConfigurationLocation().getURL())).getProtocol(), url.getPath(), null))) != null && file.exists()) {
            configurationPath = file.getAbsolutePath();
        }
        return configurationPath;
    }

    public static String getBrowserSimConfigFolderPath() throws URISyntaxException, IOException {
        return String.valueOf(PreferencesUtil.getAbsolutePathToConfigurationFolder()) + SEPARATOR + USER_PREFERENCES_FOLDER;
    }

    private static String getArchitecture(IProcess process) {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0) {
            return PlatformUtil.parseArch((String)text);
        }
        return null;
    }

    public static String argumentsListToString(List<String> list) {
        String str = "";
        for (String s : list) {
            s = PreferencesUtil.surroundSpaces(s);
            str = String.valueOf(str) + s + " ";
        }
        return str;
    }

    private static String surroundSpaces(String str) {
        if (str.indexOf(32) >= 0) {
            return String.valueOf('\"') + str + '\"';
        }
        return str;
    }

    public static boolean requiresGTK3() {
        LinuxSystem.LinuxDistro distro = LinuxSystem.INSTANCE.getDistro();
        return LinuxSystem.INSTANCE.REDHAT.equals(distro) && distro.getVersion().compareTo("7") >= 0;
    }
}

