/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.util.BeanPresentationUtil;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.AssignableBeanFilters;
import org.jboss.tools.common.java.IParametedType;

public class AssignableBeansDialog
extends PopupDialog {
    IInjectionPoint injectionPoint;
    AssignableBeanFilters filters = null;
    Set<IBean> beans = new HashSet<IBean>();
    Set<IBean> eligibleBeans = new HashSet<IBean>();
    Set<IBean> resolvedBeans = new HashSet<IBean>();
    Composite composite;
    boolean showHideOptions = true;
    Group filterPanel;
    CheckboxTreeViewer filterView;
    private Text fFilterText;
    TableViewer list;
    private static final String SHOW_HIDE_PANEL = "SHOW_HIDE_PANEL";
    private static final String FILTER_OPTION = "FILTER_OPTION_";
    static CheckboxContentProvider checkboxContentProvider = new CheckboxContentProvider();
    TextFilter textFilter = new TextFilter();
    static Color gray = new Color(null, 128, 128, 128);
    static Color black = Display.getDefault().getSystemColor(28);
    static StyledString.Styler RESOLVED_NAME = new DefaultStyler(black, true, false);
    static StyledString.Styler ELIGIBLE_NAME = new DefaultStyler(black, false, false);
    static StyledString.Styler ELIGIBLE_QUALIFIER = new DefaultStyler(gray, false, false);
    static StyledString.Styler DISABLED = new DefaultStyler(gray, false, false);

    public AssignableBeansDialog(Shell parentShell) {
        super(parentShell, 0, true, true, true, true, true, "title", null);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.filters = new AssignableBeanFilters();
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.showHideOptions = settings.getBoolean(SHOW_HIDE_PANEL);
        for (AssignableBeanFilters.Checkbox c : this.filters.getAllOptions().values()) {
            String name = FILTER_OPTION + c.id;
            boolean bl = c.state = !"false".equals(settings.get(name));
        }
        this.filters.getRoot().state = true;
    }

    public void setInjectionPoint(IInjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
        this.filters.init(injectionPoint);
        this.initSettings();
        this.beans = new HashSet<IBean>(injectionPoint.getCDIProject().getBeans(false, injectionPoint));
        this.eligibleBeans = new HashSet<IBean>(this.beans);
        int i = AssignableBeanFilters.OPTION_UNAVAILABLE_BEANS + 1;
        while (i < AssignableBeanFilters.OPTION_ELIMINATED_AMBIGUOUS) {
            AssignableBeanFilters.Filter f = this.filters.getFilter(i);
            if (f != null) {
                f.filter(this.eligibleBeans);
            }
            ++i;
        }
        this.resolvedBeans = new HashSet<IBean>(injectionPoint.getCDIProject().getBeans(true, injectionPoint));
    }

    String computeTitle() {
        StringBuffer result = new StringBuffer();
        result.append("@Inject ");
        if (this.injectionPoint instanceof IInjectionPointParameter) {
            IMethod m = ((IInjectionPointParameter)this.injectionPoint).getBeanMethod().getMethod();
            result.append(m.getElementName()).append("(");
        }
        for (IQualifierDeclaration d : this.injectionPoint.getQualifierDeclarations()) {
            result.append("@").append(d.getType().getElementName()).append(" ");
        }
        IParametedType type = this.injectionPoint.getMemberType();
        result.append(type.getType().getElementName()).append(" ");
        if (this.injectionPoint instanceof IInjectionPointParameter) {
            result.append(((IInjectionPointParameter)this.injectionPoint).getName());
            result.append(")");
        } else {
            result.append(this.injectionPoint.getSourceMember().getElementName());
        }
        return result.toString();
    }

    protected void buttonPressed(int buttonId) {
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        this.fFilterText = this.createFilterText(parent);
        return fViewMenuButtonComposite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CDIExtensionsMessages.ASSIGNABLE_BEANS_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setFont(parent.getFont());
        this.setTitleText(this.computeTitle());
        this.createListView(this.composite);
        if (this.showHideOptions) {
            this.createFilterView(this.composite);
        }
        this.installFilter();
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    void createListView(Composite parent) {
        this.list = new TableViewer(parent, 2820);
        GridData g = new GridData(1808);
        this.list.getControl().setLayoutData((Object)g);
        this.list.setContentProvider((IContentProvider)new ListContent());
        this.list.setLabelProvider((IBaseLabelProvider)new LP());
        this.list.setInput((Object)this.injectionPoint);
        this.list.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object o;
                ISelection s = event.getSelection();
                if (!s.isEmpty() && s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof IBean) {
                    ((IBean)o).open();
                    AssignableBeansDialog.this.close();
                }
            }
        });
        this.list.getTable().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Widget w;
                ViewerCell cell = AssignableBeansDialog.this.list.getCell(new Point(e.x, e.y));
                if (cell != null && (w = cell.getItem()) != null && w.getData() != null) {
                    AssignableBeansDialog.this.list.setSelection((ISelection)new StructuredSelection(w.getData()));
                }
                AssignableBeansDialog.this.list.getTable().setCursor(cell == null ? null : AssignableBeansDialog.this.list.getTable().getDisplay().getSystemCursor(21));
            }
        });
        this.list.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AssignableBeansDialog.this.gotoSelectedElement();
            }
        });
        this.list.refresh();
    }

    protected void gotoSelectedElement() {
        ISelection s = this.list.getSelection();
        if (!s.isEmpty() && s instanceof IStructuredSelection) {
            IBean b = (IBean)((IStructuredSelection)s).getFirstElement();
            b.open();
            this.close();
        }
    }

    void createFilterView(Composite parent) {
        Group g = this.filterPanel = new Group(parent, 0);
        g.setBackground(parent.getBackground());
        g.setText("Show/Hide");
        g.setLayoutData((Object)new GridData(1042));
        g.setLayout((Layout)new GridLayout(1, false));
        this.filterView = new CheckboxTreeViewer((Composite)g, 0);
        this.filterView.setAutoExpandLevel(3);
        this.filterView.setContentProvider((IContentProvider)checkboxContentProvider);
        this.filterView.setInput((Object)this.filters.getRoot());
        for (AssignableBeanFilters.Checkbox c : this.filters.getAllOptions().values()) {
            this.filterView.setChecked((Object)c, true);
        }
        this.filterView.getControl().setBackground(g.getBackground());
        g.setData((Object)new GridData(1808));
        this.filterView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((AssignableBeanFilters.Checkbox)event.getElement()).state = event.getChecked();
                AssignableBeansDialog.this.filterView.refresh();
                AssignableBeansDialog.this.list.refresh();
            }
        });
        this.filterView.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                AssignableBeanFilters.Checkbox c = (AssignableBeanFilters.Checkbox)element;
                return c.parent != null && !c.parent.state;
            }

            public boolean isChecked(Object element) {
                AssignableBeanFilters.Checkbox c = (AssignableBeanFilters.Checkbox)element;
                return c.state;
            }
        });
    }

    protected Control getFocusControl() {
        return this.getFilterText();
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AssignableBeansDialog.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AssignableBeansDialog.this.list.getTable().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AssignableBeansDialog.this.list.getTable().setFocus();
                }
                if (e.character == '\u001b') {
                    AssignableBeansDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssignableBeansDialog.this.list.refresh();
            }
        });
    }

    protected String getId() {
        return AssignableBeansDialog.class.getName();
    }

    protected Point getDefaultSize() {
        return new Point(700, 400);
    }

    protected Point getDefaultLocation(Point size) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getActiveShell() == null) {
            return super.getDefaultLocation(size);
        }
        Rectangle b = display.getActiveShell().getBounds();
        int x = b.x + (b.width - size.x) / 2;
        int y = b.y + (b.height - size.y) / 2;
        return new Point(x, y);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        dialogMenu.add((IAction)new ShowHideAction());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = CDIExtensionsPlugin.getDefault().getDialogSettings().getSection(this.getId());
        if (settings == null && this.filters != null && this.injectionPoint != null) {
            settings = CDIExtensionsPlugin.getDefault().getDialogSettings().addNewSection(this.getId());
            settings.put(SHOW_HIDE_PANEL, true);
            for (AssignableBeanFilters.Checkbox c : this.filters.getAllOptions().values()) {
                settings.put(FILTER_OPTION + c.id, "" + c.state);
            }
        }
        return settings;
    }

    public boolean close() {
        this.saveFilterOptions();
        return super.close();
    }

    private void saveFilterOptions() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SHOW_HIDE_PANEL, this.showHideOptions);
        for (AssignableBeanFilters.Checkbox c : this.filters.getAllOptions().values()) {
            settings.put(FILTER_OPTION + c.id, "" + c.state);
        }
    }

    public List<IBean> getDisplayedBeans() {
        Object o;
        ArrayList<IBean> bs = new ArrayList<IBean>();
        int index = 0;
        while ((o = this.list.getElementAt(index)) instanceof IBean) {
            bs.add((IBean)o);
            ++index;
        }
        return bs;
    }

    public boolean isFilterEnabled(int index) {
        AssignableBeanFilters.Checkbox c = this.filters.getOption(index);
        return c != null && c.state;
    }

    public void setFilterEnabled(int index, boolean value) {
        AssignableBeanFilters.Checkbox c = this.filters.getOption(index);
        if (c == null) {
            return;
        }
        c.state = value;
        this.filterView.refresh();
        this.list.refresh();
    }

    public Collection<AssignableBeanFilters.Checkbox> getOptions() {
        return this.filters.getAllOptions().values();
    }

    protected void setFiltersEnabled(boolean enabled) {
        if (enabled != this.showHideOptions) {
            this.showHideOptions = enabled;
            if (!enabled && this.filterPanel != null) {
                this.filterPanel.dispose();
                this.filterPanel = null;
                this.filterView = null;
            } else if (enabled && this.filterPanel == null) {
                this.createFilterView(this.composite);
            }
            this.composite.update();
            this.composite.layout(true);
        }
    }

    static class CheckboxContentProvider
    implements ITreeContentProvider {
        CheckboxContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return ((AssignableBeanFilters.Checkbox)parentElement).children.toArray(new AssignableBeanFilters.Checkbox[0]);
        }

        public Object getParent(Object element) {
            return ((AssignableBeanFilters.Checkbox)element).parent;
        }

        public boolean hasChildren(Object element) {
            return !((AssignableBeanFilters.Checkbox)element).children.isEmpty();
        }
    }

    private static class DefaultStyler
    extends StyledString.Styler {
        private Color foreground;
        private boolean bold;
        private boolean italic;

        public DefaultStyler(Color foreground, boolean bold, boolean italic) {
            this.foreground = foreground;
            this.italic = italic;
            this.bold = bold;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.foreground != null) {
                textStyle.foreground = this.foreground;
            }
            if (this.italic) {
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            if (this.bold) {
                textStyle.font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
        }
    }

    class LP
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        LP() {
        }

        public void update(ViewerCell cell) {
            ELIGIBLE_QUALIFIER = DISABLED;
            Object element = cell.getElement();
            StyledString styledString = this.getStyledText(element);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
            super.update(cell);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            IBean b = (IBean)element;
            RESOLVED_NAME = new DefaultStyler(black, true, false);
            StyledString.Styler nameStyler = AssignableBeansDialog.this.resolvedBeans.contains(b) ? RESOLVED_NAME : (AssignableBeansDialog.this.eligibleBeans.contains(b) ? ELIGIBLE_NAME : DISABLED);
            StyledString sb = new StyledString();
            String kind = BeanPresentationUtil.getBeanKind((IBean)b);
            if (kind != null) {
                sb.append(kind, nameStyler).append(' ');
            }
            sb.append(b.getElementName(), nameStyler);
            StyledString.Styler qualifierStyler = AssignableBeansDialog.this.eligibleBeans.contains(b) ? ELIGIBLE_QUALIFIER : DISABLED;
            sb.append(BeanPresentationUtil.getBeanLocation((IBean)b, (boolean)false), qualifierStyler);
            return sb;
        }

        public Image getImage(Object element) {
            return CDIImages.getImageByElement((ICDIElement)((ICDIElement)element));
        }
    }

    class ListContent
    implements IStructuredContentProvider {
        ListContent() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            String key;
            HashSet<IBean> bs = new HashSet<IBean>(AssignableBeansDialog.this.beans);
            HashSet<String> keys = new HashSet<String>();
            LP p = new LP();
            AssignableBeansDialog.this.filters.getRoot().filter(bs);
            AssignableBeansDialog.this.textFilter.filter(bs);
            TreeMap<String, IBean> map = new TreeMap<String, IBean>();
            for (IBean b : bs) {
                String key2;
                if (!AssignableBeansDialog.this.resolvedBeans.contains(b) || keys.contains(key2 = p.getText(b))) continue;
                map.put(key2, b);
                keys.add(key2);
            }
            ArrayList sorted = new ArrayList();
            sorted.addAll(map.values());
            bs.removeAll(map.values());
            map.clear();
            for (IBean b : bs) {
                if (!AssignableBeansDialog.this.eligibleBeans.contains(b) || keys.contains(key = p.getText(b))) continue;
                map.put(key, b);
                keys.add(key);
            }
            sorted.addAll(map.values());
            bs.removeAll(map.values());
            map.clear();
            for (IBean b : bs) {
                key = p.getText(b);
                if (keys.contains(key)) continue;
                map.put(key, b);
                keys.add(key);
            }
            sorted.addAll(map.values());
            return sorted.toArray(new IBean[0]);
        }
    }

    class ShowHideAction
    extends Action {
        public ShowHideAction() {
            super("Show/Hide panel", 2);
            this.setChecked(AssignableBeansDialog.this.showHideOptions);
        }

        public void run() {
            AssignableBeansDialog.this.setFiltersEnabled(this.isChecked());
        }
    }

    class TextFilter
    implements AssignableBeanFilters.Filter {
        SearchPattern patternMatcher = new SearchPattern();

        TextFilter() {
        }

        @Override
        public void filter(Set<IBean> beans) {
            String text;
            if (AssignableBeansDialog.this.fFilterText != null && !AssignableBeansDialog.this.fFilterText.isDisposed() && (text = AssignableBeansDialog.this.fFilterText.getText()).length() > 0) {
                this.patternMatcher.setPattern(text);
                Iterator<IBean> it = beans.iterator();
                while (it.hasNext()) {
                    IBean bean = it.next();
                    if (this.patternMatcher.matches(bean.getElementName())) continue;
                    it.remove();
                }
            }
        }
    }
}

