/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.IInformationItem;
import org.jboss.tools.cdi.text.ext.hyperlink.ITestableCDIHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class EventHyperlink
extends AbstractHyperlink
implements ITestableCDIHyperlink,
IInformationItem {
    IInjectionPoint event;

    public EventHyperlink(IRegion region, IInjectionPoint event, IDocument document) {
        this.event = event;
        this.setRegion(region);
        this.setDocument(document);
    }

    protected void doHyperlink(IRegion region) {
        IEditorPart part = null;
        if (this.event != null && this.event.getClassBean() != null) {
            try {
                part = JavaUI.openInEditor((IJavaElement)this.event.getClassBean().getBeanClass());
            }
            catch (JavaModelException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            catch (PartInitException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            IType element = this.event.getClassBean().getBeanClass();
            if (this.event instanceof IInjectionPointField) {
                element = ((IInjectionPointField)this.event).getField();
            } else if (this.event instanceof IInjectionPointParameter) {
                element = ((IInjectionPointParameter)this.event).getBeanMethod().getMethod();
            }
            if (part != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)element);
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        return String.valueOf(CDIExtensionsMessages.CDI_EVENT_HYPERLINK_OPEN_EVENT) + " " + this.event.getElementName();
    }

    @Override
    public ICDIElement getCDIElement() {
        return this.event;
    }

    public Set<? extends ICDIElement> getCDIElements() {
        return null;
    }
}

