/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.DeleteAllDisposerAnnotationsProcessor;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.DeletePreviewWizard;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.refactoring.TestableResolutionWithRefactoringProcessor;

public class DeleteAllDisposerDuplicantMarkerResolution
implements IQuickFix,
TestableResolutionWithRefactoringProcessor {
    private String label;
    private IMethod method;
    private IFile file;
    private String description;

    public DeleteAllDisposerDuplicantMarkerResolution(IMethod method) {
        this.label = MessageFormat.format(CDIUIMessages.DELETE_ALL_DISPOSER_DUPLICANT_MARKER_RESOLUTION_TITLE, method.getElementName());
        this.method = method;
        try {
            this.file = (IFile)method.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        this.description = this.getPreview();
    }

    public String getLabel() {
        return this.label;
    }

    private void internal_run() {
        DeleteAllDisposerAnnotationsProcessor processor = new DeleteAllDisposerAnnotationsProcessor(this.file, this.method, this.label);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
        DeletePreviewWizard wizard = new DeletePreviewWizard((Refactoring)refactoring);
        wizard.showWizard();
    }

    public void run(IMarker marker) {
        this.internal_run();
    }

    public RefactoringProcessor getRefactoringProcessor() {
        return new DeleteAllDisposerAnnotationsProcessor(this.file, this.method, this.label);
    }

    private String getPreview() {
        RefactoringProcessor processor = this.getRefactoringProcessor();
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.getEntryMatchingSeverity(4) != null) {
                return this.label;
            }
            status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
            if (status.getEntryMatchingSeverity(4) != null) {
                return this.label;
            }
            CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
            return MarkerResolutionUtils.getPreview((Change)rootChange);
        }
        catch (OperationCanceledException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        catch (CoreException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_REMOVE);
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.internal_run();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

