/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.cdi.ui.wizard.QualifierSelectionProvider;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.generation.JavaBeanGenerator;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.common.ui.widget.editor.TextFieldEditor;

public class NewAnnotationLiteralWizardPage
extends NewClassWizardPage {
    protected QualifierSelectionProvider qualifiersProvider = new QualifierSelectionProvider();
    CompositeEditor qualifiers = null;
    String defaultTypeName = null;
    protected StatusInfo qualifierStatus = new StatusInfo();
    ICDIAnnotation selected = null;

    public NewAnnotationLiteralWizardPage() {
        this.setTitle(CDIUIMessages.NEW_ANNOTATION_LITERAL_WIZARD_PAGE_NAME);
        this.setDescription(CDIUIMessages.NEW_ANNOTATION_LITERAL_WIZARD_DESCRIPTION);
        this.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIAnnotationWizBan.png"));
        this.qualifiersProvider.setMulti(false);
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.defaultTypeName = null;
        if (!selection.isEmpty()) {
            Object o = selection.iterator().next();
            IType type = null;
            if (o instanceof IType) {
                type = (IType)o;
            } else if (o instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)o;
                try {
                    IType[] ts = cu.getTypes();
                    if (ts != null && ts.length > 0) {
                        type = ts[0];
                    }
                }
                catch (JavaModelException e) {
                    CDICorePlugin.getDefault().logError((Throwable)e);
                }
            }
            boolean isInterface = false;
            try {
                isInterface = type != null && type.isInterface();
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError((Throwable)e);
            }
            if (isInterface) {
                String name = "";
                try {
                    name = type.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException javaModelException) {
                    name = type.getFullyQualifiedName();
                }
                IPackageFragmentRoot r = this.getPackageFragmentRoot();
                if (r != null) {
                    IQualifier q;
                    ICDIProject cdi = NewCDIAnnotationWizardPage.getCDIProject(r.getJavaProject());
                    IQualifier iQualifier = q = cdi != null ? cdi.getQualifier(name) : null;
                    if (q != null) {
                        this.selected = q;
                        ArrayList<String> interfacesNames = new ArrayList<String>();
                        interfacesNames.add(name);
                        this.setSuperInterfaces(interfacesNames, true);
                        this.superInterfacesChanged();
                        this.setSuperClass("javax.enterprise.util.AnnotationLiteral<" + type.getElementName() + ">", false);
                        this.setDefaultTypeName(name);
                    }
                }
            }
        }
        this.doStatusUpdate();
    }

    void setDefaultTypeName(String interfaceName) {
        boolean isDefault;
        int d = interfaceName.lastIndexOf(46);
        int b = interfaceName.indexOf(60);
        if (b < 0) {
            b = interfaceName.length();
        }
        String elementName = interfaceName.substring(d + 1, b);
        String typeName = String.valueOf(elementName) + "Literal";
        typeName = String.valueOf(typeName) + interfaceName.substring(b);
        String currentTypeName = this.getTypeName();
        boolean bl = isDefault = currentTypeName == null || currentTypeName.length() == 0 || currentTypeName.equals(this.defaultTypeName);
        if (isDefault) {
            this.setTypeName(typeName, true);
            this.typeNameChanged();
        }
        this.defaultTypeName = typeName;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.onQualifiersChange();
        this.doStatusUpdate();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        buf.replace(range.getOffset(), 0, sb.toString());
        boolean isDefault = this.modifyMethodContent(newType, imports, monitor, lineDelimiter);
        if (isDefault) {
            this.createInstanceField(newType, imports, monitor, lineDelimiter);
        }
    }

    protected void createCustomFields(Composite composite) {
        this.createQualifierField(composite);
    }

    protected void createQualifierField(Composite composite) {
        this.qualifiers = (CompositeEditor)this.createQualifierCompositeEditor("qualifiers", CDIUIMessages.FIELD_EDITOR_QUALIFIER_LABEL, "");
        this.qualifiers.doFillIntoGrid((Object)composite);
        this.setQualifiers(this.getPackageFragmentRoot());
        this.qualifiers.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                NewAnnotationLiteralWizardPage.this.validateQualifierSelection(o);
            }
        });
    }

    void validateQualifierSelection(Object value) {
        boolean done = false;
        if (value != null) {
            String name = value.toString();
            IPackageFragmentRoot r = this.getPackageFragmentRoot();
            if (r != null) {
                ICDIProject cdi = NewCDIAnnotationWizardPage.getCDIProject(r.getJavaProject());
                IQualifier iQualifier = this.selected = cdi != null ? cdi.getQualifier(name) : null;
                if (this.selected != null) {
                    ArrayList<String> interfacesNames = new ArrayList<String>();
                    interfacesNames.add(name);
                    this.setSuperInterfaces(interfacesNames, true);
                    this.superInterfacesChanged();
                    this.setSuperClass("javax.enterprise.util.AnnotationLiteral<" + this.selected.getSourceType().getElementName() + ">", false);
                    this.setDefaultTypeName(name);
                    done = true;
                }
            }
        }
        if (!done) {
            this.selected = null;
            this.setSuperInterfaces(new ArrayList(), true);
            this.superInterfacesChanged();
        }
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        super.setPackageFragmentRoot(root, canBeModified);
        this.setQualifiers(root);
        if (this.qualifiers != null) {
            this.validateQualifierSelection(this.qualifiers.getValue());
        }
    }

    void setQualifiers(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.qualifiersProvider.setProject(null);
        if (root != null && (cdi = NewCDIAnnotationWizardPage.getCDIProject(jp = root.getJavaProject())) != null) {
            this.qualifiersProvider.setProject(cdi);
        }
    }

    protected IField createInstanceField(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        imports.addImport("javax.enterprise.util.AnnotationLiteral");
        IType fieldType = this.selected.getSourceType();
        imports.addImport(fieldType.getFullyQualifiedName());
        String access = "public static final ";
        String initialization = "new " + type.getElementName() + "()";
        IJavaElement[] cs = type.getChildren();
        IJavaElement sibling = cs == null || cs.length == 0 ? null : cs[0];
        IField m = this.createField(type, sibling, imports, "INSTANCE", fieldType.getElementName(), access, initialization, monitor, lineDelimiter);
        return m;
    }

    protected IField createField(IType type, IJavaElement sibling, NewTypeWizardPage.ImportsManager imports, String name, String fieldType, String access, String initialization, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = this.isAddComments();
        String fieldHeader = String.valueOf(access) + " " + fieldType + " " + name;
        if (initialization != null) {
            fieldHeader = String.valueOf(fieldHeader) + "= " + initialization;
        }
        fieldHeader = String.valueOf(fieldHeader) + ";" + lineDelimiter;
        IField m = type.createField(fieldHeader, sibling, true, null);
        this.editField(cu, m, fieldType, fieldHeader, lineDelimiter);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editField(ICompilationUnit cu, IField m, String javatype, String fieldHeader, String lineDelimiter) throws CoreException {
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = m.getSourceRange();
        IBuffer buf = cu.getBuffer();
        StringBuffer sb = new StringBuffer(lineDelimiter);
        if (this.isAddComments()) {
            String fieldComment = CodeGeneration.getFieldComment((ICompilationUnit)cu, (String)javatype, (String)m.getElementName(), (String)lineDelimiter);
            sb.append(fieldComment).append(lineDelimiter);
        }
        sb.append(fieldHeader);
        String formattedContent = JavaBeanGenerator.codeFormat2((int)4, (String)sb.toString(), (int)1, (String)lineDelimiter, (IJavaProject)cu.getJavaProject());
        if (formattedContent != null && formattedContent.startsWith("\t")) {
            formattedContent = formattedContent.substring(1);
        }
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo result;
        List list = this.getSuperInterfaces();
        if (list != null && !list.isEmpty()) {
            this.setDefaultTypeName(list.get(0).toString());
        }
        if (!(result = (StatusInfo)super.superInterfacesChanged()).isError() && (list == null || list.isEmpty())) {
            result.setError("Please select qualifier.");
        }
        return result;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    void onQualifiersChange() {
    }

    public IFieldEditor createQualifierCompositeEditor(String name, String label, String defaultValue) {
        if (this.selected != null) {
            defaultValue = this.selected.getSourceType().getFullyQualifiedName();
        }
        CompositeEditor editor = new CompositeEditor(name, label, (Object)defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, this.createSelectAction(), (Object)"")});
        return editor;
    }

    ButtonFieldEditor.ButtonPressedAction createSelectAction() {
        return new ButtonFieldEditor.ButtonPressedAction("Browse"){

            public void run() {
                NewAnnotationLiteralWizardPage.this.selected = (ICDIAnnotation)NewAnnotationLiteralWizardPage.this.runAddAction();
                if (NewAnnotationLiteralWizardPage.this.selected != null) {
                    NewAnnotationLiteralWizardPage.this.qualifiers.setValue((Object)NewAnnotationLiteralWizardPage.this.selected.getSourceType().getFullyQualifiedName());
                }
            }
        };
    }

    protected Object runAddAction() {
        Object[] os;
        FilteredItemsSelectionDialog dialog;
        int result;
        if (this.qualifiersProvider != null && (result = (dialog = this.qualifiersProvider.createSelectionDialog()).open()) == 0 && (os = dialog.getResult()) != null) {
            Object[] objectArray = os;
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ICDIAnnotation v = this.qualifiersProvider.getSelected(o);
                if (v != null) {
                    return v;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setQualifier(String type) {
        this.qualifiers.setValue((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean modifyMethodContent(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        IMethod[] ms = type.getMethods();
        IMethod sibling = null;
        ArrayList<String[]> fields = new ArrayList<String[]>();
        IMethod constructor = null;
        int i = 0;
        while (i < ms.length) {
            block17: {
                StringBuffer sb;
                int end;
                int start;
                IBuffer buf;
                block19: {
                    ISourceRange range;
                    block18: {
                        ICompilationUnit cu;
                        block16: {
                            if (!ms[i].isConstructor()) break block16;
                            constructor = ms[i];
                            break block17;
                        }
                        if (sibling == null) {
                            sibling = ms[i];
                        }
                        ICompilationUnit iCompilationUnit = cu = type.getCompilationUnit();
                        synchronized (iCompilationUnit) {
                            cu.reconcile(0, true, null, null);
                        }
                        buf = cu.getBuffer();
                        range = ms[i].getSourceRange();
                        start = -1;
                        end = -1;
                        sb = new StringBuffer();
                        if (!"void".equals(ms[i].getReturnType()) && !"V".equals(ms[i].getReturnType())) break block18;
                        end = buf.getContents().indexOf("}", range.getOffset());
                        if (end < 0 || (end = buf.getContents().lastIndexOf(lineDelimiter, end)) < 0 || end < range.getOffset()) break block17;
                        start = end;
                        break block19;
                    }
                    start = buf.getContents().indexOf("return", range.getOffset());
                    if (start < 0 || start > range.getOffset() + range.getLength() || (end = buf.getContents().indexOf(";", start += 7)) < 0) break block17;
                    ++end;
                }
                String methodName = ms[i].getElementName();
                String fieldName = methodName;
                sb.append(fieldName).append(";");
                buf.replace(start, end - start, sb.toString());
                fields.add(new String[]{ms[i].getReturnType(), fieldName});
            }
            ++i;
        }
        i = 0;
        while (i < fields.size()) {
            String[] data = (String[])fields.get(i);
            String fieldType = data[0];
            String fieldName = data[1];
            ParametedType t = NewCDIAnnotationWizardPage.getCDIProject(this.getPackageFragmentRoot().getJavaProject()).getNature().getTypeFactory().getParametedType((IMember)type, fieldType);
            if (t != null) {
                data[0] = t.getSimpleName();
                this.createField(type, (IJavaElement)constructor, imports, fieldName, t.getSimpleName(), "private final", null, monitor, lineDelimiter);
            }
            ++i;
        }
        if (constructor != null) {
            constructor.delete(true, monitor);
        }
        if (!fields.isEmpty()) {
            String[] data;
            String constructorContents = "public " + type.getElementName() + "(";
            String comments = "/**" + lineDelimiter;
            int i2 = 0;
            while (i2 < fields.size()) {
                data = (String[])fields.get(i2);
                String fieldType = data[0];
                String fieldName = data[1];
                comments = String.valueOf(comments) + " * @param " + fieldName + lineDelimiter;
                if (i2 > 0) {
                    constructorContents = String.valueOf(constructorContents) + ", ";
                }
                constructorContents = String.valueOf(constructorContents) + fieldType + " " + fieldName;
                ++i2;
            }
            comments = String.valueOf(comments) + "*/" + lineDelimiter;
            constructorContents = String.valueOf(constructorContents) + ") {" + lineDelimiter;
            i2 = 0;
            while (i2 < fields.size()) {
                data = (String[])fields.get(i2);
                String fieldName = data[1];
                constructorContents = String.valueOf(constructorContents) + "this." + fieldName + " = " + fieldName + ";" + lineDelimiter;
                ++i2;
            }
            constructorContents = String.valueOf(constructorContents) + "}" + lineDelimiter;
            if (this.isAddComments()) {
                constructorContents = String.valueOf(comments) + constructorContents;
            }
            type.createMethod(constructorContents, (IJavaElement)sibling, true, monitor);
        }
        return fields.isEmpty();
    }
}

