/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.core.buildpath;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.jdt.core.JDTExtActivator;
import org.jboss.tools.common.jdt.core.Messages;
import org.jboss.tools.common.jdt.core.buildpath.ILibraryMaterializationPostProcessor;
import org.jboss.tools.common.jdt.core.buildpath.ILibraryMaterializationPostProcessorFactory;
import org.jboss.tools.common.util.FileUtil;

public class MaterializeLibraryJob
extends WorkspaceJob {
    private final IContainer libFolder;
    private final IJavaProject javaProject;
    private final Map<IPath, String> jars;
    private final IClasspathContainer containerToRemove;
    private final boolean keepSourceAttachments;

    public MaterializeLibraryJob(IJavaProject javaProject, IClasspathContainer containerToMaterialize, Map<IPath, String> jars, IContainer libFolder, boolean keepSourceAttachments) {
        super(Messages.Materialize_Library);
        if (javaProject == null || javaProject.getProject() == null) {
            throw new IllegalArgumentException("Project must not be null");
        }
        if (containerToMaterialize == null) {
            throw new IllegalArgumentException("Container to materialize must not be null");
        }
        if (libFolder == null) {
            throw new IllegalArgumentException("Destination library folder must not be null");
        }
        this.javaProject = javaProject;
        this.libFolder = libFolder;
        this.containerToRemove = containerToMaterialize;
        this.jars = jars;
        this.keepSourceAttachments = keepSourceAttachments;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath containerToRemovePath = this.containerToRemove.getPath();
        LinkedHashSet<IClasspathEntry> newCpes = null;
        if (this.jars != null && !this.jars.isEmpty()) {
            newCpes = this.copyClasspathEntries(monitor, rootPath);
        }
        this.removeClasspathContainer(this.javaProject, containerToRemovePath);
        if (newCpes != null && !newCpes.isEmpty()) {
            IClasspathEntry[] entries = new IClasspathEntry[newCpes.size()];
            newCpes.toArray(entries);
            this.addToClasspath(this.javaProject, entries, monitor);
        }
        ILibraryMaterializationPostProcessor[] iLibraryMaterializationPostProcessorArray = this.getPostProcessors();
        int n = iLibraryMaterializationPostProcessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILibraryMaterializationPostProcessor processor = iLibraryMaterializationPostProcessorArray[n2];
            processor.execute(this.javaProject, containerToRemovePath, monitor);
            ++n2;
        }
        IProject resourceToRefresh = this.libFolder.getProject();
        if (resourceToRefresh == null) {
            resourceToRefresh = ResourcesPlugin.getWorkspace().getRoot();
        }
        resourceToRefresh.refreshLocal(2, monitor);
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    private LinkedHashSet<IClasspathEntry> copyClasspathEntries(IProgressMonitor monitor, IPath rootPath) throws CoreException, JavaModelException {
        jarSize = this.jars.size();
        monitor.beginTask(Messages.Materialize_Library, jarSize);
        if (this.libFolder instanceof IFolder) {
            this.mkdirs((IFolder)this.libFolder, monitor);
        }
        destination = this.libFolder.getLocation();
        newCpes = new LinkedHashSet<IClasspathEntry>(jarSize);
        var10_7 = cpEntries = this.containerToRemove.getClasspathEntries();
        var9_8 = cpEntries.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            entry = var10_7[var8_9];
            if (entry.getEntryKind() == 1) {
                sourceFilePath = entry.getPath();
                fileName = this.jars.get(sourceFilePath);
                if (fileName != null) {
                    monitor.subTask(fileName);
                    destinationFilePath = destination.append(fileName);
                    try {
                        if (this.javaProject.findPackageFragmentRoot(destinationFilePath) != null || !this.copy(sourceFilePath, destinationFilePath)) ** GOTO lbl32
                        relativePath = new Path("/").append(this.libFolder.getFullPath()).append(fileName);
                        newEntry = this.getNewClasspathEntry(entry, relativePath);
                        newCpes.add(newEntry);
                    }
                    catch (IOException e) {
                        status = new Status(4, "org.jboss.tools.common.jdt", NLS.bind((String)Messages.MaterializeLibraryJob_error_copying_file, (Object)fileName), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
            } else if (entry.getEntryKind() == 2) {
                newCpes.add(entry);
            }
lbl32:
            // 6 sources

            ++var8_9;
        }
        return newCpes;
    }

    private ILibraryMaterializationPostProcessor[] getPostProcessors() {
        ILibraryMaterializationPostProcessorFactory ppFactory = JDTExtActivator.getDefault().getLibraryMaterializationPostProcessorFactory();
        ILibraryMaterializationPostProcessor[] postProcessors = ppFactory.getLibraryMaterializationPostProcessors();
        return postProcessors;
    }

    private IClasspathEntry getNewClasspathEntry(IClasspathEntry entry, IPath destinationFilePath) throws CoreException {
        try {
            return JavaCore.newLibraryEntry((IPath)destinationFilePath, (IPath)(this.keepSourceAttachments ? entry.getSourceAttachmentPath() : null), (IPath)(this.keepSourceAttachments ? entry.getSourceAttachmentRootPath() : null), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])entry.getExtraAttributes(), (boolean)entry.isExported());
        }
        catch (Exception e) {
            Status status = new Status(4, "org.jboss.tools.common.jdt", NLS.bind((String)Messages.MaterializeLibraryJob_Error_creating_classpath_entry, (Object)e.getMessage()), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void addToClasspath(IJavaProject javaProject, IClasspathEntry[] newCpes, IProgressMonitor monitor) throws JavaModelException {
        if (newCpes.length > 0) {
            IClasspathEntry[] originalClasspathEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newClasspath = new IClasspathEntry[originalClasspathEntries.length + newCpes.length];
            System.arraycopy(originalClasspathEntries, 0, newClasspath, 0, originalClasspathEntries.length);
            System.arraycopy(newCpes, 0, newClasspath, originalClasspathEntries.length, newCpes.length);
            javaProject.setRawClasspath(newClasspath, monitor);
        }
    }

    private boolean copy(IPath sourceFilePath, IPath destinationFilePath) throws IOException {
        File sourcefile = sourceFilePath.toFile();
        if (sourcefile.isFile()) {
            File destinationFile = destinationFilePath.toFile();
            FileUtil.copyFile((File)sourcefile, (File)destinationFile);
            if (destinationFile.exists()) {
                return true;
            }
        }
        return false;
    }

    private void removeClasspathContainer(IJavaProject javaProject, IPath containerToRemovePath) throws JavaModelException {
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!containerToRemovePath.equals((Object)entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    private void mkdirs(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                this.mkdirs((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, monitor);
        } else {
            IFolder x = folder;
            while (x instanceof IFolder && x.isDerived()) {
                x.setDerived(false, monitor);
                x = x.getParent();
            }
        }
    }
}

