/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLClassHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String XML_CLASS_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_CLASS";

    @Override
    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = XMLClassHyperlinkPartitioner.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = XML_CLASS_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            String className;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (start < 0 || start > offset || end < offset) {
                return null;
            }
            String text = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            int positionInText = offset - start - bStart;
            text = document.get(bStart + start, bEnd - bStart);
            if (positionInText >= text.length()) {
                return null;
            }
            int classNameStart = positionInText;
            while (classNameStart > 0 && !Character.isWhitespace(text.charAt(classNameStart))) {
                --classNameStart;
            }
            boolean firstOrAfterDot = true;
            int classNameEnd = classNameStart;
            while (classNameEnd < text.length()) {
                if (Character.isWhitespace(text.charAt(classNameEnd))) break;
                if ('.' == text.charAt(classNameEnd)) {
                    if (firstOrAfterDot) {
                        return null;
                    }
                    firstOrAfterDot = true;
                } else if (firstOrAfterDot) {
                    if (!Character.isJavaIdentifierStart(text.charAt(classNameEnd))) {
                        return null;
                    }
                    firstOrAfterDot = false;
                } else if (!Character.isJavaIdentifierPart(text.charAt(classNameEnd))) {
                    return null;
                }
                ++classNameEnd;
            }
            if ((className = text.substring(classNameStart, classNameEnd).trim()).length() == 0 || className.startsWith(".") || className.endsWith(".")) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

