/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobResultFuture
implements Future<IStatus> {
    private AtomicBoolean done = new AtomicBoolean(false);
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private ArrayBlockingQueue<IStatus> queue = new ArrayBlockingQueue(1);
    private Job job;

    public JobResultFuture(Job job) {
        this.job = job;
        this.addJobFinishedListener(job);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.isRunning(this.job) || mayInterruptIfRunning) {
            this.cancelled.set(true);
            this.job.cancel();
            Thread thread = this.job.getThread();
            if (thread != null) {
                thread.interrupt();
            }
        }
        return this.isRunning(this.job);
    }

    private boolean isRunning(Job job) {
        return job.getState() == 4;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        if (this.isCancelled()) {
            return false;
        }
        return this.done.get();
    }

    @Override
    public IStatus get() throws InterruptedException, ExecutionException {
        return this.queue.poll();
    }

    @Override
    public IStatus get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.queue.poll(timeout, unit);
    }

    private void addJobFinishedListener(Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                JobResultFuture.this.queue.offer(event.getResult());
                JobResultFuture.this.done.set(true);
            }
        });
    }
}

