/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.field.CheckBoxField;

public class CheckBoxFieldEditor
extends BaseFieldEditor
implements PropertyChangeListener {
    private Control checkBoxControl;

    public CheckBoxFieldEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        return new Control[]{this.createCheckBoxControl((Composite)composite)};
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.getCheckBoxControl()};
    }

    public Control getCheckBoxControl() {
        return this.createCheckBoxControl(null);
    }

    private Control createCheckBoxControl(Composite parent) {
        if (this.checkBoxControl == null) {
            CheckBoxField checkBoxFild = new CheckBoxField(parent);
            checkBoxFild.addPropertyChangeListener(this);
            this.checkBoxControl = checkBoxFild.getCheckBox();
            if (this.getValue() instanceof Boolean) {
                checkBoxFild.getCheckBox().setSelection(((Boolean)this.getValue()).booleanValue());
            }
        } else if (parent != null) {
            Assert.isTrue((this.checkBoxControl.getParent() == parent ? 1 : 0) != 0);
        }
        return this.checkBoxControl;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public void save(Object object) {
    }

    @Override
    public void setEditable(boolean ediatble) {
    }

    @Override
    public void setValue(Object newValue) {
        if (this.checkBoxControl != null) {
            ((Button)this.checkBoxControl).setSelection(Boolean.parseBoolean(newValue.toString()));
        }
        super.setValue(newValue);
    }

    @Override
    public void doFillIntoGrid(Object parent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setValue(evt.getNewValue());
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }
}

