/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.wizard.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class NewServiceWizardPage
extends NewClassWizardPage {
    String defaultTypeName = null;
    protected StatusInfo interfaceNameStatus = new StatusInfo();
    IFieldEditor interfaceField;

    public NewServiceWizardPage() {
        this.setTitle(CommonUIMessages.NEW_SERVICE_WIZARD_PAGE_NAME);
        this.setDescription(CommonUIMessages.NEW_SERVICE_WIZARD_DESCRIPTION);
        this.setImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor("wizard/NewJavaServiceProviderWizBan.png"));
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.defaultTypeName = null;
        if (selection != null && !selection.isEmpty()) {
            Object o = selection.iterator().next();
            IType type = null;
            if (o instanceof IType) {
                type = (IType)o;
            } else if (o instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)o;
                try {
                    IType[] ts = cu.getTypes();
                    if (ts != null && ts.length > 0) {
                        type = ts[0];
                    }
                }
                catch (JavaModelException e) {
                    CommonUIPlugin.getDefault().logError(e);
                }
            }
            boolean isInterface = false;
            try {
                isInterface = type != null && type.isInterface();
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
            if (isInterface) {
                ArrayList<String> interfacesNames = new ArrayList<String>();
                String name = "";
                try {
                    name = type.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException javaModelException) {
                    name = type.getFullyQualifiedName();
                }
                interfacesNames.add(name);
                this.setSuperInterfaces(interfacesNames, true);
                this.superInterfacesChanged();
                this.setDefaultTypeName(name);
            }
        }
        this.setModifiers(this.getModifiers(), true);
        try {
            Field f = NewTypeWizardPage.class.getDeclaredField("fOtherMdfButtons");
            if (f != null) {
                f.setAccessible(true);
                SelectionButtonDialogFieldGroup g = (SelectionButtonDialogFieldGroup)f.get((Object)this);
                g.enableSelectionButton(0, false);
            }
        }
        catch (Exception e) {
            CommonUIPlugin.getDefault().logError(e);
        }
        this.doStatusUpdate();
    }

    void setDefaultTypeName(String interfaceName) {
        boolean isDefault;
        int d = interfaceName.lastIndexOf(46);
        int b = interfaceName.indexOf(60);
        if (b < 0) {
            b = interfaceName.length();
        }
        String elementName = interfaceName.substring(d + 1, b);
        String typeName = String.valueOf(elementName) + "Service";
        String currentTypeName = this.getTypeName();
        boolean bl = isDefault = currentTypeName == null || currentTypeName.length() == 0 || currentTypeName.equals(this.defaultTypeName);
        if (isDefault) {
            this.setTypeName(typeName, true);
            this.typeNameChanged();
        }
        this.defaultTypeName = typeName;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.onInterfaceChange();
        this.doStatusUpdate();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected void createCustomFields(Composite composite) {
        this.createInterfaceField(composite);
    }

    protected void createInterfaceField(Composite composite) {
        this.interfaceField = SwtFieldEditorFactory.INSTANCE.createButtonFieldEditor("Interface", CommonUIMessages.NEW_SERVICE_WIZARD_INTERFACES_LABEL, "", new ButtonFieldEditor.ButtonPressedAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS){

            public void run() {
                Object[] os;
                OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(NewServiceWizardPage.this.getShell(), false, (IRunnableContext)NewServiceWizardPage.this.getContainer(), NewServiceWizardPage.this.getJavaProject() != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{NewServiceWizardPage.this.getJavaProject()}) : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[0]), 10);
                dialog.setTitle(CommonUIMessages.NEW_SERVICE_WIZARD_SELECT_SERVICE_TYPE_TITLE);
                if (dialog.open() == 0 && (os = dialog.getResult()) != null && os.length == 1) {
                    IType t = (IType)os[0];
                    NewServiceWizardPage.this.interfaceField.setValue(t.getFullyQualifiedName());
                }
            }
        }, new IValidator(){

            @Override
            public Map<String, IStatus> validate(Object value, Object context) {
                return null;
            }
        });
        List s = this.getSuperInterfaces();
        if (!s.isEmpty()) {
            this.setServiceType((String)s.get(0));
        }
        this.interfaceField.doFillIntoGrid(composite);
        this.interfaceField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewServiceWizardPage.this.onInterfaceChange();
            }
        });
    }

    public void setServiceType(String typeName) {
        this.interfaceField.setValue(typeName);
    }

    protected void onInterfaceChange() {
        this.interfaceNameStatus = new StatusInfo();
        String q = this.interfaceField == null ? "" : this.interfaceField.getValue().toString().trim();
        boolean isInterface = false;
        boolean isClass = false;
        if (this.getJavaProject() != null && q.length() > 0) {
            String qRaw = q;
            if (qRaw.indexOf(60) > 0) {
                qRaw = qRaw.substring(0, qRaw.indexOf(60));
            }
            try {
                IType t = EclipseJavaUtil.findType((IJavaProject)this.getJavaProject(), (String)qRaw);
                if (t != null) {
                    isInterface = t.isInterface();
                    boolean bl = isClass = !t.isInterface();
                    if (Flags.isFinal((int)t.getFlags())) {
                        this.interfaceNameStatus.setError(CommonUIMessages.NEW_SERVICE_WIZARD_SERVICE_TYPE_FINAL);
                    } else if (isClass && !Flags.isAbstract((int)t.getFlags())) {
                        this.interfaceNameStatus.setWarning(CommonUIMessages.NEW_SERVICE_WIZARD_SERVICE_TYPE_CONCRETE);
                    }
                } else {
                    isInterface = true;
                    this.interfaceNameStatus.setError(NLS.bind((String)CommonUIMessages.NEW_SERVICE_WIZARD_SERVICE_TYPE_NOT_EXISTS, (Object)q));
                }
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
                this.interfaceNameStatus.setError(NLS.bind((String)CommonUIMessages.NEW_SERVICE_WIZARD_SERVICE_TYPE_NOT_EXISTS, (Object)q));
            }
        }
        if (q.length() == 0) {
            this.interfaceNameStatus.setError(CommonUIMessages.NEW_SERVICE_WIZARD_SERVICE_TYPE_EMPTY);
        }
        if (isInterface) {
            ArrayList<String> is = new ArrayList<String>();
            if (q.length() > 0) {
                is.add(q.trim());
            }
            this.setSuperInterfaces(is, true);
            this.setSuperClass("", true);
        } else if (isClass) {
            this.setSuperInterfaces(new ArrayList(), true);
            this.setSuperClass(q, true);
        }
        this.doStatusUpdate();
    }

    protected IStatus superInterfacesChanged() {
        List list = this.getSuperInterfaces();
        if (list != null && !list.isEmpty()) {
            this.setDefaultTypeName(list.get(0).toString());
        }
        StatusInfo result = (StatusInfo)super.superInterfacesChanged();
        return result;
    }

    protected IStatus superClassChanged() {
        String n = this.getSuperClass();
        if (n != null && n.length() > 0 && !n.endsWith("Object")) {
            this.setDefaultTypeName(n);
        }
        StatusInfo result = (StatusInfo)super.superClassChanged();
        return result;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        if (!CommonUIMessages.NEW_SERVICE_WIZARD_DESCRIPTION.equals(this.getDescription())) {
            this.setDescription(CommonUIMessages.NEW_SERVICE_WIZARD_DESCRIPTION);
        }
        IStatus[] ns = new IStatus[status.length + 1];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.interfaceNameStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    public boolean isToBeRegisteredInMetaInf() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (!this.getControl().isVisible() && visible && this.fSuperInterfacesStatus.matches(4) && !this.fTypeNameStatus.matches(4)) {
            this.setDescription(this.fSuperInterfacesStatus.getMessage());
        }
        super.setVisible(visible);
    }

    protected String getSuperInterfacesLabel() {
        return CommonUIMessages.NEW_SERVICE_WIZARD_INTERFACES_LABEL;
    }

    public String getServiceRawType() {
        return this.interfaceField == null ? "" : NewServiceWizardPage.toRawTypeName(this.interfaceField.getValueAsString());
    }

    private static String toRawTypeName(String typeName) {
        return typeName.indexOf(60) >= 0 ? typeName.substring(0, typeName.indexOf(60)) : typeName;
    }
}

