/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.validation.IAsYouTypeValidator;
import org.jboss.tools.common.validation.IJavaElementValidator;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.ValidationContext;

public class EditorValidationContext
extends ValidationContext {
    private IDocument document;
    private Set<IStringValidator> stringValidators;
    private Set<IJavaElementValidator> javaElementValidators;

    public EditorValidationContext(IProject project, IDocument document) {
        super(project);
        this.document = document;
        this.stringValidators = new HashSet<IStringValidator>();
        this.javaElementValidators = new HashSet<IJavaElementValidator>();
        for (IValidator validator : this.validators) {
            if (validator instanceof IStringValidator) {
                this.stringValidators.add((IStringValidator)validator);
            }
            if (!(validator instanceof IJavaElementValidator)) continue;
            this.javaElementValidators.add((IJavaElementValidator)validator);
        }
    }

    @Override
    protected boolean shouldValidate(IValidator validator, IProject project) {
        return validator instanceof IAsYouTypeValidator && ((IAsYouTypeValidator)validator).shouldValidateAsYouType(project);
    }

    public IDocument getDocument() {
        return this.document;
    }

    public Set<IStringValidator> getStringValidators() {
        return this.stringValidators;
    }

    public Set<IJavaElementValidator> getJavaElementValidators() {
        return this.javaElementValidators;
    }
}

