/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.ValidationContext;
import org.jboss.tools.common.validation.ValidationErrorManager;

public class PreferenceInfoManager {
    private static Map<String, IPreferenceInfo> infos = Collections.synchronizedMap(new HashMap());

    public static void register(String problemType, IPreferenceInfo info) {
        if (!infos.containsKey(problemType)) {
            infos.put(problemType, info);
        }
    }

    public static IPreferenceInfo getPreferenceInfo(String problemType) {
        IPreferenceInfo info;
        if (problemType == null) {
            problemType = ValidationErrorManager.DEFAULT_VALIDATION_MARKER;
        }
        if ((info = infos.get(problemType)) == null) {
            ValidationContext.loadValidatorByProblemType(problemType);
            info = infos.get(problemType);
        }
        return info;
    }
}

