/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.util.UniquePaths;
import org.jboss.tools.common.validation.ValidationMessages;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

public class LinkCollection {
    protected Map<String, Set<IPath>> resourcesByVariableName = new HashMap<String, Set<IPath>>();
    protected Map<IPath, Set<String>> variableNamesByResource = new HashMap<IPath, Set<String>>();
    protected Map<String, Set<IPath>> resourcesByDeclaringVariableName = new HashMap<String, Set<IPath>>();
    protected Map<IPath, Set<String>> declaringVariableNamesByResource = new HashMap<IPath, Set<String>>();
    protected Set<IPath> unnamedResources = new HashSet<IPath>();
    private String id;
    protected int modifications = 0;

    public LinkCollection(String id) {
        this.id = id;
    }

    public void disableResourcesByVariableName() {
        this.resourcesByVariableName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkedResource(String variableName, IPath linkedResourcePath, boolean declaration) {
        if (linkedResourcePath == null) {
            throw new IllegalArgumentException(ValidationMessages.VALIDATION_CONTEXT_LINKED_RESOURCE_PATH_MUST_NOT_BE_NULL);
        }
        if (variableName == null) {
            throw new IllegalArgumentException(ValidationMessages.VALIDATION_CONTEXT_VARIABLE_NAME_MUST_NOT_BE_NULL);
        }
        linkedResourcePath = UniquePaths.getInstance().intern(linkedResourcePath);
        if (this.resourcesByVariableName != null) {
            LinkCollection linkCollection = this;
            synchronized (linkCollection) {
                Set<IPath> linkedResources = this.resourcesByVariableName.get(variableName);
                if (linkedResources == null) {
                    linkedResources = new HashSet<IPath>();
                    this.resourcesByVariableName.put(variableName, linkedResources);
                }
                if (linkedResources.add(linkedResourcePath)) {
                    ++this.modifications;
                }
            }
        }
        Set<String> variableNames = null;
        LinkCollection linkCollection = this;
        synchronized (linkCollection) {
            variableNames = this.variableNamesByResource.get(linkedResourcePath);
            if (variableNames == null) {
                variableNames = new HashSet<String>();
                this.variableNamesByResource.put(linkedResourcePath, variableNames);
            }
            if (variableNames.add(variableName.intern())) {
                ++this.modifications;
            }
        }
        if (declaration) {
            linkCollection = this;
            synchronized (linkCollection) {
                Set<IPath> linkedResources = this.resourcesByDeclaringVariableName.get(variableName);
                if (linkedResources == null) {
                    linkedResources = new HashSet<IPath>();
                    this.resourcesByDeclaringVariableName.put(variableName, linkedResources);
                }
                if (linkedResources.add(linkedResourcePath)) {
                    ++this.modifications;
                }
            }
            variableNames = this.declaringVariableNamesByResource.get(linkedResourcePath);
            if (variableNames == null) {
                variableNames = new HashSet<String>();
                this.declaringVariableNamesByResource.put(linkedResourcePath, variableNames);
            }
            if (variableNames.add(variableName)) {
                ++this.modifications;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinkedResource(String name, IPath linkedResourcePath) {
        Set<String> variableNames;
        if (this.resourcesByVariableName != null) {
            LinkCollection linkCollection = this;
            synchronized (linkCollection) {
                Set<IPath> linkedResources = this.resourcesByVariableName.get(name);
                if (linkedResources != null && linkedResources.remove(linkedResourcePath)) {
                    ++this.modifications;
                }
                if (linkedResources.isEmpty()) {
                    this.resourcesByVariableName.remove(name);
                }
            }
        }
        if ((variableNames = this.variableNamesByResource.get(linkedResourcePath)) != null && variableNames.remove(name)) {
            ++this.modifications;
        }
        if (variableNames.isEmpty()) {
            this.variableNamesByResource.remove(linkedResourcePath);
        }
        LinkCollection linkCollection = this;
        synchronized (linkCollection) {
            Set<IPath> linkedResources = this.resourcesByDeclaringVariableName.get(name);
            if (linkedResources != null && linkedResources.remove(linkedResourcePath)) {
                ++this.modifications;
            }
            if (linkedResources.isEmpty()) {
                this.resourcesByDeclaringVariableName.remove(name);
            }
        }
        variableNames = this.declaringVariableNamesByResource.get(linkedResourcePath);
        if (variableNames != null && variableNames.remove(name)) {
            ++this.modifications;
        }
        if (variableNames.isEmpty()) {
            this.declaringVariableNamesByResource.remove(linkedResourcePath);
        }
    }

    public void removeLinkedResources(Set<IPath> resources) {
        for (IPath resource : resources) {
            this.removeLinkedResource(resource);
        }
    }

    public synchronized void removeLinkedResource(IPath resource) {
        Set<IPath> linkedResources;
        Set<String> resourceNames = this.variableNamesByResource.get(resource);
        if (resourceNames != null && this.resourcesByVariableName != null) {
            for (String name : resourceNames) {
                linkedResources = this.resourcesByVariableName.get(name);
                if (linkedResources == null) continue;
                if (linkedResources.remove(resource)) {
                    ++this.modifications;
                }
                if (!linkedResources.isEmpty()) continue;
                this.resourcesByVariableName.remove(name);
            }
        }
        if (this.variableNamesByResource.remove(resource) != null) {
            ++this.modifications;
        }
        if ((resourceNames = this.declaringVariableNamesByResource.get(resource)) != null) {
            for (String name : resourceNames) {
                linkedResources = this.resourcesByDeclaringVariableName.get(name);
                if (linkedResources == null) continue;
                if (linkedResources.remove(resource)) {
                    ++this.modifications;
                }
                if (!linkedResources.isEmpty()) continue;
                this.resourcesByDeclaringVariableName.remove(name);
            }
        }
        if (this.declaringVariableNamesByResource.remove(resource) != null) {
            ++this.modifications;
        }
    }

    public Set<IPath> getResourcesByVariableName(String variableName, boolean declaration) {
        if (!declaration && this.resourcesByVariableName == null) {
            throw new RuntimeException("ResourcesByVariableName are disabled.");
        }
        return declaration ? this.resourcesByDeclaringVariableName.get(variableName) : this.resourcesByVariableName.get(variableName);
    }

    public synchronized Set<String> getVariableNamesByResource(IPath fullPath, boolean declaration) {
        return declaration ? this.declaringVariableNamesByResource.get(fullPath) : this.variableNamesByResource.get(fullPath);
    }

    public void addUnnamedResource(IPath fullPath) {
        if (this.unnamedResources.add(fullPath)) {
            ++this.modifications;
        }
    }

    public Set<IPath> getUnnamedResources() {
        return this.unnamedResources;
    }

    public void removeUnnamedResource(IPath fullPath) {
        if (this.unnamedResources.remove(fullPath)) {
            ++this.modifications;
        }
    }

    public synchronized void clearAll() {
        if (this.resourcesByVariableName != null) {
            this.resourcesByVariableName.clear();
        }
        this.variableNamesByResource.clear();
        this.declaringVariableNamesByResource.clear();
        this.resourcesByDeclaringVariableName.clear();
        this.unnamedResources.clear();
        this.modifications = 0;
    }

    public synchronized void store(Element root, Map<String, String> pathAliases) {
        Set<IPath> paths = this.variableNamesByResource.keySet();
        for (IPath path : paths) {
            Element linkedResource;
            String pathAlias = ELReference.getAlias(pathAliases, (String)path.toString());
            Set<String> variables = this.variableNamesByResource.get(path);
            if (variables == null || variables.isEmpty()) continue;
            StringBuilder declarationFalseNames = new StringBuilder();
            StringBuilder declarationTrueNames = new StringBuilder();
            for (String name : variables) {
                String nameAlias = ELReference.getAlias(pathAliases, (String)name);
                if (this.checkDeclaration(path, name)) {
                    declarationTrueNames.append(nameAlias).append(";");
                    continue;
                }
                declarationFalseNames.append(nameAlias).append(";");
            }
            if (declarationFalseNames.length() > 0) {
                linkedResource = XMLUtilities.createElement((Element)root, (String)"linked-resource");
                linkedResource.setAttribute("path", pathAlias);
                linkedResource.setAttribute("name", declarationFalseNames.toString());
            }
            if (declarationTrueNames.length() <= 0) continue;
            linkedResource = XMLUtilities.createElement((Element)root, (String)"linked-resource");
            linkedResource.setAttribute("path", pathAlias);
            linkedResource.setAttribute("name", declarationTrueNames.toString());
            linkedResource.setAttribute("declaration", "true");
        }
        StringBuilder unnamedPaths = new StringBuilder();
        for (IPath unnamedPath : this.unnamedResources) {
            String pathAlias = ELReference.getAlias(pathAliases, (String)unnamedPath.toString());
            unnamedPaths.append(pathAlias).append(";");
        }
        if (unnamedPaths.length() > 0) {
            Element unnamedPathElement = XMLUtilities.createElement((Element)root, (String)"unnamed-path");
            unnamedPathElement.setAttribute("path", ELReference.getAlias(pathAliases, (String)unnamedPaths.toString()));
        }
        this.modifications = 0;
    }

    public void load(Element root, Map<String, String> pathAliases) {
        Element[] unnamedPathElement;
        if (root == null) {
            return;
        }
        Element[] linkedResources = XMLUtilities.getChildren((Element)root, (String)"linked-resource");
        if (linkedResources != null) {
            int i = 0;
            while (i < linkedResources.length) {
                String path = linkedResources[i].getAttribute("path");
                if (path != null && path.trim().length() != 0) {
                    if (path.indexOf(59) > 0) {
                        path = path.substring(0, path.indexOf(59));
                    }
                    path = ELReference.getPath(pathAliases, (String)path);
                    Path pathObject = new Path(path);
                    String name1 = linkedResources[i].getAttribute("name");
                    if (name1 != null && name1.trim().length() != 0) {
                        String[] names;
                        String declaration = linkedResources[i].getAttribute("declaration");
                        boolean declarationFlag = "true".equals(declaration);
                        String[] stringArray = names = name1.split(";");
                        int n = names.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            name = ELReference.getPath(pathAliases, (String)name);
                            this.addLinkedResource(name, (IPath)pathObject, declarationFlag);
                            ++n2;
                        }
                    }
                }
                ++i;
            }
        }
        if ((unnamedPathElement = XMLUtilities.getChildren((Element)root, (String)"unnamed-path")) != null) {
            int i = 0;
            while (i < unnamedPathElement.length) {
                String[] paths;
                String path1 = unnamedPathElement[i].getAttribute("path");
                String[] stringArray = paths = path1.split(";");
                int n = paths.length;
                int n3 = 0;
                while (n3 < n) {
                    String path = stringArray[n3];
                    path = ELReference.getPath(pathAliases, (String)path);
                    Path pathObject = new Path(path);
                    this.addUnnamedResource((IPath)pathObject);
                    ++n3;
                }
                ++i;
            }
        }
        this.modifications = 0;
    }

    private boolean checkDeclaration(IPath resource, String variableName) {
        Set<IPath> paths = this.resourcesByDeclaringVariableName.get(variableName);
        if (paths != null) {
            for (IPath path : paths) {
                if (!path.equals((Object)resource)) continue;
                return true;
            }
        }
        return false;
    }

    public int getModificationsSinceLastStore() {
        return this.modifications;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEmpty() {
        return (this.resourcesByVariableName == null || this.resourcesByVariableName.isEmpty()) && this.variableNamesByResource.isEmpty() && this.resourcesByDeclaringVariableName.isEmpty() && this.declaringVariableNamesByResource.isEmpty() && this.unnamedResources.isEmpty();
    }
}

