/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.model.VManagerModel;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;

public class VHelper {
    private static VManagerModel managerModel;

    private VHelper() {
    }

    public static VManager getManager() {
        return managerModel == null ? null : managerModel.getManager();
    }

    public static void setManager(VManagerModel mgr) {
        if (managerModel == null) {
            managerModel = mgr;
        } else if (managerModel != mgr) {
            VerificationPlugin.getPluginLog().logInfo("Warning: VManager already exists.");
        }
    }

    public static VRule[] getRules(VManager manager, VObject object) {
        if (manager == null || object == null) {
            return null;
        }
        ArrayList<VRule> result = new ArrayList<VRule>();
        VEntity entity = object.getEntity();
        VRuleSet[] ruleSets = manager.getRuleSets();
        int sign = manager.getMinSignificance();
        VHelper.filterRuleSets(ruleSets, entity, sign, result);
        return result.toArray(new VRule[result.size()]);
    }

    private static void filterRuleSets(VRuleSet[] ruleSets, VEntity entity, int sign, List<VRule> result) {
        if (ruleSets == null) {
            return;
        }
        int i = 0;
        while (i < ruleSets.length) {
            VHelper.filterRuleSets(ruleSets[i].getRuleSets(), entity, sign, result);
            ++i;
        }
        i = 0;
        while (i < ruleSets.length) {
            VHelper.filterRules(ruleSets[i].getRules(), entity, sign, result);
            ++i;
        }
    }

    public static VRule[] getRules(VManager manager, VObject object, VRuleSet ruleSet) {
        ArrayList<VRule> result = new ArrayList<VRule>();
        VEntity entity = object.getEntity();
        int sign = manager.getMinSignificance();
        VHelper.filterRules(ruleSet.getRules(), entity, sign, result);
        VHelper.filterRuleSets(ruleSet.getRuleSets(), entity, sign, result);
        return result.toArray(new VRule[result.size()]);
    }

    private static void filterRules(VRule[] rules, VEntity entity, int sign, List<VRule> result) {
        int j = 0;
        while (j < rules.length) {
            VRule rule = rules[j];
            if (rule.getSignificance() >= sign) {
                VEntity[] entities = rule.getEntities();
                int k = 0;
                while (k < entities.length) {
                    if (entity != null && entity.getName() != null && entities[k] != null && entities[k].getName() != null) {
                        String name = entities[k].getName();
                        if (entity.getName().equals(name) || entity.isDescendant(name)) {
                            result.add(rule);
                            break;
                        }
                    }
                    ++k;
                }
            }
            ++j;
        }
    }
}

