/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.handler.VerifyHandler;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class VerifyRuleSetAllHandler
extends VerifyHandler {
    protected VRuleSet ruleSet;

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        VModel vmodel = VModelFactory.getModel(object.getModel());
        HashMap<String, ArrayList<VRule>> entities = new HashMap<String, ArrayList<VRule>>();
        VRule[] rules = this.ruleSet.getRules();
        int i = 0;
        while (i < rules.length) {
            VRule rule = rules[i];
            if (rule.isEnabled() && rule.getAction() != null) {
                VEntity[] ent = rule.getEntities();
                int j = 0;
                while (j < ent.length) {
                    String name = ent[j].getName();
                    ArrayList<VRule> r = (ArrayList<VRule>)entities.get(name);
                    if (r == null) {
                        r = new ArrayList<VRule>();
                        entities.put(name, r);
                    }
                    r.add(rule);
                    ++j;
                }
            }
            ++i;
        }
        VObject vobject = vmodel.getObjectByPath(object.getPath());
        this.check(entities, vobject, object.getModel());
    }

    public boolean isEnabled(XModelObject object) {
        return this.ruleSet != null && this.ruleSet.isEnabled();
    }

    public VRuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(VRuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }
}

