/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.dialog.UICommandListDialog;
import org.jboss.tools.forge.ui.internal.ext.dialog.WizardDialogHelper;
import org.jboss.tools.forge.ui.util.ForgeHelper;

public class RunForgeCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashMap<String, String> values;
        final String wizardName = event.getParameter("org.jboss.tools.forge.ui.runForgeCommand.commandName");
        final String wizardTitle = event.getParameter("org.jboss.tools.forge.ui.runForgeCommand.commandTitle");
        String wizardValues = event.getParameter("org.jboss.tools.forge.ui.runForgeCommand.commandValues");
        if (wizardValues == null) {
            values = null;
        } else {
            values = new HashMap<String, String>();
            String[] stringArray = wizardValues.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] split = entry.split("=");
                values.put(split[0], split[1]);
                ++n2;
            }
        }
        try {
            final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            if (!ForgeRuntimeState.RUNNING.equals((Object)FurnaceRuntime.INSTANCE.getState())) {
                Job job = ForgeHelper.createStartRuntimeJob((ForgeRuntime)FurnaceRuntime.INSTANCE);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RunForgeCommandHandler.this.openWizard(window, wizardName, wizardTitle, values);
                            }
                        });
                    }
                });
                job.schedule();
            } else {
                this.openWizard(window, wizardName, wizardTitle, values);
            }
        }
        catch (Exception e) {
            ForgeUIPlugin.log(e);
        }
        return null;
    }

    private void openWizard(IWorkbenchWindow window, String wizardName, String wizardTitle, Map<String, ?> values) {
        IStructuredSelection currentSelection = UICommandListDialog.getCurrentSelection(window);
        ITextSelection textSelection = UICommandListDialog.getTextSelection(window);
        WizardDialogHelper helper = new WizardDialogHelper(window.getShell(), currentSelection, textSelection);
        UICommand command = helper.getCommand(wizardName);
        helper.openWizard(wizardTitle, command, values);
    }
}

