/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.jobs.ImportNewProjectsJob;
import org.jboss.tools.forge.ui.internal.jobs.RefreshInitialSelectionJob;
import org.jboss.tools.forge.ui.internal.jobs.ShowFinalSelectionJob;
import org.jboss.tools.forge.ui.internal.jobs.UpdateProjectConfigurationJob;

public class ForgeWizardHelper {
    private ImportNewProjectsJob importNewProjectsJob;
    private RefreshInitialSelectionJob refreshInitialSelectionJob;
    private UpdateProjectConfigurationJob updateProjectConfigurationJob;
    private ShowFinalSelectionJob showFinalSelectionJob;

    public ForgeWizardHelper() {
        this.initializeJobs();
    }

    private void initializeJobs() {
        this.importNewProjectsJob = new ImportNewProjectsJob();
        this.refreshInitialSelectionJob = new RefreshInitialSelectionJob();
        this.updateProjectConfigurationJob = new UpdateProjectConfigurationJob();
        this.showFinalSelectionJob = new ShowFinalSelectionJob();
        this.importNewProjectsJob.setSuccessor(this.refreshInitialSelectionJob);
        this.refreshInitialSelectionJob.setSuccessor(this.updateProjectConfigurationJob);
        this.updateProjectConfigurationJob.setSuccessor(this.showFinalSelectionJob);
    }

    public void onFinish(UIContextImpl context) {
        this.refreshInitialSelectionJob.setContext(context);
        this.showFinalSelectionJob.setContext(context);
        this.importNewProjectsJob.schedule();
    }

    public void onCancel(UIContextImpl context) {
        this.updateProjectConfigurationJob.setPomFile(null);
    }

    public void onCreate(UIContextImpl context) {
        IResource resource;
        UISelection selection = context.getInitialSelection();
        if (selection != null && (resource = selection.getResource()) != null) {
            this.updateProjectConfigurationJob.setPomFile(this.determinePomFile(selection.getResource()));
        }
    }

    private IFile determinePomFile(IResource resource) {
        IFile result = null;
        IProject project = resource.getProject();
        if (project != null) {
            result = project.getFile((IPath)new Path("pom.xml"));
        }
        return result;
    }
}

