/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.util;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.forge.addon.database.tools.connections.ConnectionProfileManager;
import org.jboss.forge.addon.database.tools.connections.ConnectionProfileManagerProvider;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.console.ForgeConsoleManager;
import org.jboss.tools.forge.ui.internal.ext.database.ConnectionProfileManagerImpl;
import org.jboss.tools.forge.ui.internal.ext.importer.ImportEclipseProjectListener;
import org.jboss.tools.forge.ui.internal.part.ForgeConsoleView;

public class ForgeHelper {
    private ForgeHelper() {
    }

    public static void start(ForgeRuntime runtime) {
        ForgeHelper.createStartRuntimeJob(runtime).schedule();
    }

    public static void stop(ForgeRuntime runtime) {
        ForgeHelper.createStopRuntimeJob(runtime).schedule();
    }

    public static Job createStartRuntimeJob(final ForgeRuntime runtime) {
        final String version = runtime.getVersion();
        WorkspaceJob job = new WorkspaceJob("Starting JBoss Forge " + version){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                String taskName = "Please wait while JBoss Forge " + version + " is started.";
                monitor.beginTask(taskName, -1);
                runtime.start(monitor);
                if (runtime instanceof FurnaceRuntime) {
                    ForgeHelper.initializeFurnaceRuntime();
                }
                if (runtime.getErrorMessage() != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError(null, (String)"JBoss Forge Startup Error", (String)runtime.getErrorMessage());
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        return job;
    }

    public static Job createStopRuntimeJob(final ForgeRuntime runtime) {
        Job job = new Job("Stopping JBoss Forge " + runtime.getVersion()){

            protected IStatus run(IProgressMonitor monitor) {
                runtime.stop(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        return job;
    }

    /*
     * Unable to fully structure code
     */
    private static void initializeFurnaceRuntime() {
        forgeService = FurnaceService.INSTANCE;
        try {
            forgeService.waitUntilContainerIsStarted();
            if (true) ** GOTO lbl14
        }
        catch (InterruptedException e) {
            ForgeUIPlugin.log(e);
            return;
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException v0) {
                break;
            }
lbl14:
            // 2 sources

        } while ((projectFactory = (ProjectFactory)forgeService.lookup(ProjectFactory.class)) == null);
        if (projectFactory != null) {
            projectFactory.addProjectListener((ProjectListener)ImportEclipseProjectListener.INSTANCE);
        }
        try {
            imported = forgeService.lookupImported(ConnectionProfileManagerProvider.class);
            if (imported != null) {
                provider = (ConnectionProfileManagerProvider)imported.get();
                provider.setConnectionProfileManager((ConnectionProfileManager)new ConnectionProfileManagerImpl());
            }
        }
        catch (Throwable t) {
            ForgeUIPlugin.log(t);
        }
    }

    private static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static void showForgeConsole(ForgeRuntime forgeRuntime) {
        try {
            IWorkbenchPage activeWorkbenchPage = ForgeHelper.getActiveWorkbenchPage();
            IViewPart forgeConsoleView = activeWorkbenchPage.showView("org.jboss.tools.forge.ui.console");
            if (forgeConsoleView == null) {
                return;
            }
            ((ForgeConsoleView)forgeConsoleView).showForgeConsole(ForgeConsoleManager.INSTANCE.getConsole(forgeRuntime));
        }
        catch (Exception e) {
            ForgeUIPlugin.log(e);
        }
    }

    public static void showRuntime(ForgeRuntime forgeRuntime) {
        try {
            ForgeConsoleView forgeConsoleView = ForgeHelper.findForgeConsoleView();
            if (forgeConsoleView == null) {
                return;
            }
            forgeConsoleView.showForgeConsole(ForgeConsoleManager.INSTANCE.getConsole(forgeRuntime));
        }
        catch (Exception e) {
            ForgeUIPlugin.log(e);
        }
    }

    public static ForgeConsoleView findForgeConsoleView() {
        IWorkbenchPage activeWorkbenchPage = ForgeHelper.getActiveWorkbenchPage();
        IViewPart forgeConsoleView = activeWorkbenchPage.findView("org.jboss.tools.forge.ui.console");
        return forgeConsoleView == null ? null : (ForgeConsoleView)forgeConsoleView;
    }
}

