/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.internal.connection;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.SimpleType;
import org.jboss.tools.jmx.jolokia.internal.Activator;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.jolokia.converter.object.StringToOpenTypeConverter;
import org.jolokia.util.DateUtil;
import org.json.simple.JSONArray;

public class JolokiaJavaTypeConverter {
    private Converters jolokiaConverters = new Converters();

    public Object getJson(Object value) {
        try {
            return this.jolokiaConverters.getToJsonConverter().convertToJson(value, null, JsonConvertOptions.DEFAULT);
        }
        catch (AttributeNotFoundException e) {
            Activator.pluginLog().logError((Throwable)e);
            return value;
        }
    }

    public Object getConvertedToCorrectTypeReturnedValue(MBeanAttributeInfo mBeanAttributeInfo, Object jolokiaReturnedValue) {
        String realType = mBeanAttributeInfo != null ? mBeanAttributeInfo.getType() : null;
        return this.getConvertedToCorrectType(jolokiaReturnedValue, realType);
    }

    public Object getConvertedToCorrectType(Object jolokiaReturnedValue, String realType) {
        if (realType != null && jolokiaReturnedValue instanceof String) {
            return this.getConvertedString(jolokiaReturnedValue, realType);
        }
        if (realType != null && jolokiaReturnedValue instanceof Number) {
            return this.getConvertedNumeric((Number)jolokiaReturnedValue, realType);
        }
        if (realType != null && jolokiaReturnedValue instanceof JSONArray) {
            return this.getConvertedCollection((JSONArray)jolokiaReturnedValue, realType);
        }
        return jolokiaReturnedValue;
    }

    protected Object getConvertedString(Object jolokiaReturnedValue, String realType) {
        if (Date.class.getName().equals(realType)) {
            return DateUtil.fromISO8601((String)((String)jolokiaReturnedValue));
        }
        return this.jolokiaConverters.getToObjectConverter().convertFromString(realType, (String)jolokiaReturnedValue);
    }

    protected Object getConvertedCollection(JSONArray jolokiaReturnedValue, String realType) {
        if (Set.class.getName().equals(realType) || HashSet.class.getName().equals(realType)) {
            return new HashSet(jolokiaReturnedValue);
        }
        return jolokiaReturnedValue;
    }

    protected Object getConvertedNumeric(Number jolokiaReturnedValue, String realType) {
        StringToOpenTypeConverter openTypeConverter = this.jolokiaConverters.getToOpenTypeConverter();
        if ("int".equals(realType) || Integer.class.getName().equals(realType)) {
            return openTypeConverter.convertToObject(SimpleType.INTEGER, (Object)jolokiaReturnedValue);
        }
        if ("short".equals(realType) || Short.class.getName().equals(realType)) {
            return openTypeConverter.convertToObject(SimpleType.SHORT, (Object)jolokiaReturnedValue);
        }
        if ("float".equals(realType) || Float.class.getName().equals(realType)) {
            return openTypeConverter.convertToObject(SimpleType.FLOAT, (Object)jolokiaReturnedValue);
        }
        return jolokiaReturnedValue;
    }
}

