/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.check;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.jsf.ui.editor.check.ProjectNaturesChecker;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;

public class ProjectNaturesPartListener
implements IPartListener {
    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        boolean isCheck = true;
        String isCheckString = System.getProperty("org.jboss.tools.vpe.ENABLE_PROJECT_NATURES_CHECKER");
        if (isCheckString != null) {
            isCheck = Boolean.parseBoolean(isCheckString);
        }
        if (isCheck && WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Inform when a project might not be configured properly for Visual Page Editor")) {
            try {
                this.checkNaturesFromPart(part);
            }
            catch (CoreException e) {
                LogHelper.logError((String)"org.jboss.tools.jst.web.ui", (Throwable)e);
            }
        }
    }

    private void checkNaturesFromPart(IWorkbenchPart part) throws CoreException {
        IEditorInput editorInput;
        if (part instanceof JSPMultiPageEditor && (editorInput = ((JSPMultiPageEditor)part).getEditorInput()) instanceof IFileEditorInput) {
            ProjectNaturesChecker.getInstance().checkNatures(((IFileEditorInput)editorInput).getFile().getProject());
        }
    }
}

