/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.el.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jst.web.kb.refactoring.SearchUtil;

public class MessagesFileRenameParticipant
extends RenameParticipant {
    private static final String PROPERTIES_EXT = "properties";
    private CompositeChange rootChange;
    private IFile file;
    private String newName = null;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.rootChange = new CompositeChange(JsfUIMessages.MESSAGES_FILE_RENAME_PARTICIPANT_UPDATE_MESSAGE_BUNDLE_REFERENCES);
            this.file = (IFile)element;
            String ext = this.file.getFileExtension();
            if (PROPERTIES_EXT.equals(ext)) {
                this.newName = this.getArguments().getNewName();
                return true;
            }
        }
        return false;
    }

    private String getQualifiedName(IPath path) {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)this.file.getProject());
        if (javaProject != null) {
            IResource[] iResourceArray = EclipseResourceUtil.getJavaSourceRoots((IProject)this.file.getProject());
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IPath javaSource = resource.getFullPath();
                if (javaSource.segmentCount() == javaSource.matchingFirstSegments(path)) {
                    IPath relativePath = path.removeFirstSegments(javaSource.segmentCount());
                    String pathString = relativePath.toString();
                    pathString = pathString.replace(".properties", "");
                    pathString = pathString.replace("/", ".");
                    return pathString;
                }
                ++n2;
            }
        }
        return "";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.newName != null) {
            if (!this.newName.endsWith(".properties")) {
                status.addFatalError(JsfUIMessages.MESSAGES_FILE_RENAME_PARTICIPANT_FILE_NAME_SHOULD_BE_WITH_THE_SAME_EXTENSION);
                return status;
            }
            IPath path = this.file.getFullPath();
            this.newName = this.newName.replace(".properties", "");
            String oldName = this.getQualifiedName(path);
            String fileName = this.file.getName().replace(".properties", "");
            this.newName = oldName.replace(fileName, this.newName);
            SearchUtil su = new SearchUtil(4, oldName);
            SearchUtil.SearchResult result = su.searchInNodeAttribute(this.file.getProject(), ":loadBundle", "basename");
            if (result.getEntries().size() == 0) {
                return status;
            }
            for (SearchUtil.FileResult fr : result.getEntries()) {
                TextFileChange fileChange = new TextFileChange(fr.getFile().getName(), fr.getFile());
                MultiTextEdit root = new MultiTextEdit();
                fileChange.setEdit((TextEdit)root);
                this.rootChange.add((Change)fileChange);
                int[] nArray = fr.getPositions();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int position = nArray[n2];
                    ReplaceEdit edit = new ReplaceEdit(position, oldName.length(), this.newName);
                    fileChange.addEdit((TextEdit)edit);
                    ++n2;
                }
            }
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }
}

