/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.handlers;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IInputValidator;
import org.jboss.tools.jsf.jsf2.util.JSF2ResourceUtil;

public class NameInputValidator
implements IInputValidator {
    private static final Pattern NAME_PATTERN = Pattern.compile("([a-zA-Z]+\\d*)+");
    private IProject project;

    public NameInputValidator(IProject project) {
        this.project = project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String isValid(String newText) {
        String trim = newText.trim();
        String result = null;
        String[] split = trim.split(":", 2);
        if (split.length != 2 || trim.startsWith(":") || trim.endsWith(":") || split[0].length() == 0 || split[1].length() == 0) {
            result = "Component's name should fit in the pattern \"namespace:name\"";
        } else if (!NAME_PATTERN.matcher(split[0]).matches()) {
            result = "Namespace '" + split[0] + "' has wrong spelling, please correct";
        } else if (!NAME_PATTERN.matcher(split[1]).matches()) {
            result = "Name '" + split[1] + "' has wrong spelling, please correct";
        } else {
            IResource res;
            String nameSpaceURI = "http://java.sun.com/jsf/composite/" + split[0];
            Object fld = JSF2ResourceUtil.findResourcesFolderContainerByNameSpace((IProject)this.project, (String)nameSpaceURI);
            if (fld instanceof IFolder && (res = ((IFolder)fld).findMember(String.valueOf(split[1]) + ".xhtml")) instanceof IFile && ((IFile)res).exists()) {
                result = "Component with the same name already exists";
            }
        }
        return result;
    }
}

