/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.verification.vrules;

import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;
import org.jboss.tools.jsf.verification.vrules.JSFDefaultCheck;
import org.jboss.tools.jsf.web.JSFWebHelper;

public class CheckContextParam
extends JSFDefaultCheck {
    static String CONFIG_FILES_PARAM = JSFWebHelper.FACES_CONFIG_DATA.param;

    @Override
    public VResult[] check(VObject object) {
        XModelObject webRoot;
        XModelObject o = ((VObjectImpl)object).getModelObject();
        if (!CONFIG_FILES_PARAM.equals(o.getAttributeValue("param-name"))) {
            return null;
        }
        String value = o.getAttributeValue("param-value");
        if (value == null || value.length() == 0) {
            return null;
        }
        XModel model = this.getXModel(object);
        XModelObject xModelObject = webRoot = model == null ? null : model.getByPath("FileSystems/WEB-ROOT");
        if (webRoot == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken().trim();
            if (path.length() == 0) continue;
            XModelObject fc = XModelImpl.getByRelativePath((XModel)model, (String)path);
            if (fc == null) {
                return this.fire(object, "config.exists", "param-value", path);
            }
            String path2 = path.startsWith("/") ? path.substring(1) : path;
            XModelObject fc2 = webRoot.getChildByPath(path2);
            if (fc2 == null) {
                return this.fire(object, "config.exists", "param-value", path);
            }
            if (fc2.getModelEntity().getName().startsWith("FacesConfig")) continue;
            return this.fire(object, "config.valid", "param-value", path);
        }
        return null;
    }
}

