/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.refactoring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.jsf.jsf2.model.JSF2ComponentModelManager;
import org.jboss.tools.jsf.jsf2.refactoring.core.StructuredChanges;
import org.jboss.tools.jsf.jsf2.refactoring.core.StructuredTextFileChange;
import org.jboss.tools.jsf.jsf2.util.JSF2ComponentUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RefactoringChangesFactory {
    private static final String JSF_CONTENT_TYPE = "jsf.facelet";
    private static final String JSP_CONTENT_TYPE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String HTML_CONTENT_TYPE = "org.eclipse.wst.html.core.htmlsource";
    private static final GroupCategorySet CATEGORY_COMPOSITE_URI_RENAME = new GroupCategorySet(new GroupCategory("org.jboss.tools.jsf.jsf2.refactoring.rename.composite.uri.type", JSFUIMessages.Refactoring_JSF_2_Rename_Composite_URI_Changes, JSFUIMessages.Refactoring_JSF_2_Changes_Rename_Composite_URI));
    private static final GroupCategorySet CATEGORY_COMPOSITE_COMPONENT_RENAME = new GroupCategorySet(new GroupCategory("org.jboss.tools.jsf.jsf2.refactoring.rename.composite.uri.type", JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Component_Changes, JSFUIMessages.Refactoring_JSF_2_Changes_Rename_Composite_Component));

    public static StructuredChanges createRenameURIChanges(IResource resource, Map<String, String> urisMap) throws CoreException {
        StructuredChanges changes = new StructuredChanges(JSFUIMessages.Refactoring_JSF_2_Rename_Composite_URI_Changes);
        RefactoringChangesFactory.createRenameURIChangesRecursively(resource, urisMap, changes);
        if (changes.getChildren() == null || changes.getChildren().length == 0) {
            return null;
        }
        return changes;
    }

    public static StructuredChanges createRenameCompositeComponentsChanges(IResource resource, String uri, String oldFileName, String newFileName) throws CoreException {
        StructuredChanges changes = new StructuredChanges(JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Component_Changes);
        RefactoringChangesFactory.createRenameComponentChangesRecursively(resource, uri, oldFileName, newFileName, changes);
        if (changes.getChildren() == null || changes.getChildren().length == 0) {
            return null;
        }
        return changes;
    }

    private static void createRenameComponentChangesRecursively(IResource resource, String uri, String oldFileName, String newFileName, StructuredChanges changes) throws CoreException {
        block6: {
            block7: {
                block5: {
                    if (!(resource instanceof IFile)) break block5;
                    IFile file = (IFile)resource;
                    StructuredTextFileChange change = RefactoringChangesFactory.createRanameComponentChange(file, uri, oldFileName, newFileName);
                    if (change == null) break block6;
                    changes.add((Change)change);
                    break block6;
                }
                if (!(resource instanceof IProject)) break block7;
                IResource[] children = ((IProject)resource).members();
                if (children == null) break block6;
                int i = 0;
                while (i < children.length) {
                    RefactoringChangesFactory.createRenameComponentChangesRecursively(children[i], uri, oldFileName, newFileName, changes);
                    ++i;
                }
                break block6;
            }
            if (resource instanceof IFolder) {
                if (resource.getName().startsWith(".")) {
                    return;
                }
                IResource[] children = ((IFolder)resource).members();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        RefactoringChangesFactory.createRenameComponentChangesRecursively(children[i], uri, oldFileName, newFileName, changes);
                        ++i;
                    }
                }
            }
        }
    }

    private static StructuredTextFileChange createRanameComponentChange(IFile file, String uri, String oldName, String newName) {
        if (!RefactoringChangesFactory.isFileCorrect(file)) {
            return null;
        }
        StructuredTextFileChange fileChange = null;
        Map<String, List<Element>> compositeComponentsMap = JSF2ComponentUtil.findCompositeComponents((Node)JSF2ComponentModelManager.getReadableDOMDocument(file));
        List<Element> compositeComponents = compositeComponentsMap.get(uri);
        if (compositeComponents != null) {
            for (Element element : compositeComponents) {
                if (!oldName.equals(element.getLocalName()) || !(element instanceof IDOMElement)) continue;
                IDOMElement domElement = (IDOMElement)element;
                if (fileChange == null) {
                    fileChange = new StructuredTextFileChange(file.getFullPath().toOSString(), file);
                }
                ReplaceEdit[] edits = RefactoringChangesFactory.createReplaceEditsForElement(domElement, oldName, newName);
                int i = 0;
                while (i < edits.length) {
                    TextChangeCompatibility.addTextEdit((TextChange)fileChange, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Component, (TextEdit)edits[i], (GroupCategorySet)CATEGORY_COMPOSITE_COMPONENT_RENAME);
                    ++i;
                }
            }
        }
        return fileChange;
    }

    private static ReplaceEdit[] createReplaceEditsForElement(IDOMElement element, String oldName, String newName) {
        ReplaceEdit edit;
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>();
        String sourceString = element.getSource();
        int startOffset = element.getStartOffset();
        int endStartOffset = element.getEndStartOffset();
        int endOffset = element.getEndOffset();
        if (endOffset != endStartOffset) {
            edit = new ReplaceEdit(sourceString.lastIndexOf(oldName) + startOffset, oldName.length(), newName);
            edits.add(edit);
        }
        edit = new ReplaceEdit(startOffset + sourceString.indexOf(oldName), oldName.length(), newName);
        edits.add(edit);
        return edits.toArray(new ReplaceEdit[0]);
    }

    private static void createRenameURIChangesRecursively(IResource resource, Map<String, String> urisMap, StructuredChanges changes) throws CoreException {
        block6: {
            block7: {
                block5: {
                    if (!(resource instanceof IFile)) break block5;
                    IFile file = (IFile)resource;
                    StructuredTextFileChange change = RefactoringChangesFactory.createRanameURIChange(file, urisMap);
                    if (change == null) break block6;
                    changes.add((Change)change);
                    break block6;
                }
                if (!(resource instanceof IProject)) break block7;
                IResource[] children = ((IProject)resource).members();
                if (children == null) break block6;
                int i = 0;
                while (i < children.length) {
                    RefactoringChangesFactory.createRenameURIChangesRecursively(children[i], urisMap, changes);
                    ++i;
                }
                break block6;
            }
            if (resource instanceof IFolder) {
                if (resource.getName().startsWith(".")) {
                    return;
                }
                IResource[] children = ((IFolder)resource).members();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        RefactoringChangesFactory.createRenameURIChangesRecursively(children[i], urisMap, changes);
                        ++i;
                    }
                }
            }
        }
    }

    private static StructuredTextFileChange createRanameURIChange(IFile file, Map<String, String> urisMap) {
        IDOMAttr[] uriAttrs;
        if (!RefactoringChangesFactory.isFileCorrect(file)) {
            return null;
        }
        StructuredTextFileChange fileChange = null;
        IDOMAttr[] iDOMAttrArray = uriAttrs = JSF2ComponentUtil.findURIContainers((Node)JSF2ComponentModelManager.getReadableDOMDocument(file));
        int n = uriAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            IDOMAttr uriAttr = iDOMAttrArray[n2];
            String valueToBeReplaced = uriAttr.getValue();
            if (urisMap.containsKey(valueToBeReplaced)) {
                if (fileChange == null) {
                    fileChange = new StructuredTextFileChange(file.getFullPath().toOSString(), file);
                }
                ReplaceEdit edit = new ReplaceEdit(uriAttr.getValueRegionStartOffset() + 1, valueToBeReplaced.length(), urisMap.get(valueToBeReplaced));
                TextChangeCompatibility.addTextEdit((TextChange)fileChange, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Composite_URI, (TextEdit)edit, (GroupCategorySet)CATEGORY_COMPOSITE_URI_RENAME);
            }
            ++n2;
        }
        return fileChange;
    }

    private static boolean isFileCorrect(IFile file) {
        if (file == null) {
            return false;
        }
        if (!file.isSynchronized(0)) {
            return false;
        }
        if (file.isPhantom()) {
            return false;
        }
        if (file.isReadOnly()) {
            return false;
        }
        if (!"xhtml".equals(file.getFileExtension()) && !"jsp".equals(file.getFileExtension())) {
            IContentType contentType = IDE.getContentType((IFile)file);
            if (contentType == null) {
                return false;
            }
            String id = contentType.getId();
            if (!(JSP_CONTENT_TYPE.equals(id) || HTML_CONTENT_TYPE.equals(id) || JSF_CONTENT_TYPE.equals(id))) {
                return false;
            }
        }
        return true;
    }
}

