/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation.composite;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.web.validation.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;
import org.jboss.tools.jst.web.kb.internal.validation.WebValidator;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.ICompositeTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeComponentValidator
extends WebValidator {
    public static final String ID = "org.jboss.tools.jsf.CompositeComponentValidator";
    public static final String SHORT_ID = "jboss.jsf.core";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.jsf.ui.preferences.JSFValidationPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.jsf.ui.propertyPages.JSFValidationPreferencePage";
    public static final String MESSAGE_ID_ATTRIBUTE_NAME = "JSF2_message_id";
    public static final int UNKNOWN_COMPOSITE_COMPONENT_NAME_ID = 1;
    public static final int UNKNOWN_COMPOSITE_COMPONENT_ATTRIBUTE_ID = 2;

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, validationContext, (IValidator)manager, reporter);
        this.displaySubtask(JSFValidationMessage.SEARCHING_RESOURCES, new String[]{project.getName()});
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        HashSet<IPath> pathesToClean = new HashSet<IPath>();
        for (IFile file : changedFiles) {
            pathesToClean.add(file.getFullPath());
            if (!this.notValidatedYet((IResource)file)) continue;
            if (file.exists()) {
                ITagLibrary[] libs;
                filesToValidate.add(file);
                ITagLibrary[] iTagLibraryArray = libs = TagLibraryManager.getLibraries((IResource)file.getParent());
                int n = libs.length;
                int n2 = 0;
                while (n2 < n) {
                    ITagLibrary lib = iTagLibraryArray[n2];
                    if (lib instanceof ICompositeTagLibrary) {
                        this.collectRelatedPages(root, filesToValidate, pathesToClean, this.getComponentUri(lib.getURI(), file));
                    }
                    ++n2;
                }
                continue;
            }
            IContainer folder = file.getParent();
            if (folder == null) continue;
            String[] segemnts = folder.getFullPath().segments();
            StringBuilder libUri = new StringBuilder();
            String[] stringArray = segemnts;
            int n = segemnts.length;
            int n3 = 0;
            while (n3 < n) {
                String segment = stringArray[n3];
                if (libUri.length() == 0) {
                    if (segment.equalsIgnoreCase("resources")) {
                        libUri.append("http://java.sun.com/jsf/composite");
                    }
                } else {
                    libUri.append('/').append(segment);
                }
                ++n3;
            }
            if (libUri.length() <= "http://java.sun.com/jsf/composite".length()) continue;
            this.collectRelatedPages(root, filesToValidate, pathesToClean, this.getComponentUri(libUri.toString(), file));
        }
        this.getValidationContext().removeLinkedCoreResources(SHORT_ID, pathesToClean);
        for (IFile file : filesToValidate) {
            this.validateResource(file);
        }
        return this.OK_STATUS;
    }

    private void collectRelatedPages(IWorkspaceRoot root, Set<IFile> filesToValidate, Set<IPath> pathesToClean, String uri) {
        Set pathes = this.getValidationContext().getCoreResourcesByVariableName(SHORT_ID, uri, false);
        if (pathes != null) {
            for (IPath path : pathes) {
                IFile page = root.getFile(path);
                if (page == null || !page.isAccessible()) continue;
                filesToValidate.add(page);
                pathesToClean.add(page.getFullPath());
            }
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, validationContext, (IValidator)manager, reporter);
        this.displaySubtask(JSFValidationMessage.VALIDATING_PROJECT, new String[]{project.getName()});
        Set files = validationHelper.getProjectSetRegisteredFiles();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IFile file : files) {
            if (!file.isAccessible() || !this.notValidatedYet((IResource)file)) continue;
            filesToValidate.add(file);
        }
        for (IFile file : filesToValidate) {
            this.validateResource(file);
        }
        return this.OK_STATUS;
    }

    private String getComponentUri(String libUri, IFile file) {
        String fullName;
        String name = fullName = file.getName();
        String ext = file.getFileExtension();
        if (ext != null) {
            name = name.substring(0, name.lastIndexOf("." + ext));
        }
        return String.valueOf(libUri) + ":" + name;
    }

    private void validateResource(IFile file) {
        if (this.shouldFileBeValidated(file)) {
            this.displaySubtask(JSFValidationMessage.VALIDATING_RESOURCE, new String[]{file.getProject().getName(), file.getName()});
            this.removeAllMessagesFromResource((IResource)file);
            this.coreHelper.getValidationContextManager().addValidatedProject((org.jboss.tools.common.validation.IValidator)this, file.getProject());
            ELContext context = PageContextFactory.createPageContext((IFile)file);
            if (context != null && context instanceof IPageContext) {
                IPageContext pageContext = (IPageContext)context;
                Set uris = pageContext.getURIs();
                for (String uri : uris) {
                    if (!uri.startsWith("http://java.sun.com/jsf/composite") && !uri.startsWith("http://xmlns.jcp.org/jsf/composite")) continue;
                    IModelManager manager = StructuredModelManager.getModelManager();
                    if (manager == null) break;
                    IStructuredModel model = null;
                    try {
                        try {
                            model = manager.getModelForRead(file);
                            if (!(model instanceof IDOMModel)) break;
                            IDOMModel domModel = (IDOMModel)model;
                            IDOMDocument document = domModel.getDocument();
                            this.validateNode(file, document.getDocumentElement());
                            break;
                        }
                        catch (CoreException e) {
                            JSFModelPlugin.getPluginLog().logError((Throwable)e);
                            if (model == null) break;
                            model.releaseFromRead();
                            break;
                        }
                        catch (IOException e) {
                            JSFModelPlugin.getPluginLog().logError((Throwable)e);
                            if (model == null) break;
                            model.releaseFromRead();
                            break;
                        }
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                    }
                }
            }
        }
    }

    private void validateNode(IFile file, Node node) {
        if (node instanceof Element) {
            String namespaceURI = node.getNamespaceURI();
            if (namespaceURI != null && (namespaceURI.startsWith("http://java.sun.com/jsf/composite") || namespaceURI.startsWith("http://xmlns.jcp.org/jsf/composite"))) {
                this.validateComponent(file, node);
            }
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.validateNode(file, children.item(i));
                ++i;
            }
        }
    }

    private void validateComponent(IFile file, Node xmlComponent) {
        String tagName = xmlComponent.getLocalName();
        if (tagName == null) {
            return;
        }
        String tagLibUri = xmlComponent.getNamespaceURI();
        this.getValidationContext().addLinkedCoreResource(SHORT_ID, String.valueOf(tagLibUri) + ":" + tagName, file.getFullPath(), false);
        ITagLibrary[] libs = KbProjectFactory.getKbProject((IProject)file.getProject(), (boolean)true).getTagLibraries(tagLibUri);
        if (libs.length > 0) {
            IComponent kbComponent = libs[0].getComponent(tagName);
            if (kbComponent != null) {
                NamedNodeMap map = xmlComponent.getAttributes();
                int i = 0;
                while (i < map.getLength()) {
                    Node xmlAttribute = map.item(i);
                    String attributeName = xmlAttribute.getNodeName();
                    if (!"id".equals(attributeName) && kbComponent.getAttribute(attributeName) == null && xmlAttribute instanceof IndexedRegion) {
                        IndexedRegion region = (IndexedRegion)xmlAttribute;
                        int offset = region.getStartOffset();
                        int length = attributeName.length();
                        this.addError(JSFValidationMessage.UNKNOWN_COMPOSITE_COMPONENT_ATTRIBUTE, JSFSeverityPreferences.UNKNOWN_COMPOSITE_COMPONENT_ATTRIBUTE, new String[]{attributeName, tagName}, length, offset, (IResource)file, 2);
                    }
                    ++i;
                }
            } else {
                this.addError(file, xmlComponent, tagName);
            }
        } else {
            this.addError(file, xmlComponent, tagName);
        }
    }

    private void addError(IFile file, Node xmlComponent, String tagName) {
        if (xmlComponent instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)xmlComponent;
            int offset = region.getStartOffset();
            int length = xmlComponent.getNodeName().length() + 1;
            this.addError(JSFValidationMessage.UNKNOWN_COMPOSITE_COMPONENT_NAME, JSFSeverityPreferences.UNKNOWN_COMPOSITE_COMPONENT_NAME, new String[]{tagName}, length, offset, (IResource)file, 1);
        }
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return KbBuilder.BUILDER_ID;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        return CompositeComponentValidator.createSimpleValidatingProjectTree((IProject)project);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.jboss.tools.jsf.jsfnature") && this.validateBuilderOrder(project) && this.isEnabled(project);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
            return false;
        }
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return KBValidator.validateBuilderOrder((IProject)project, (String)this.getBuilderId(), (String)this.getId(), (SeverityPreferences)JSFSeverityPreferences.getInstance());
    }

    public boolean isEnabled(IProject project) {
        return JSFSeverityPreferences.isValidationEnabled(project);
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JSFSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return JSFSeverityPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target, int messageId) {
        IMarker marker = this.addError(message, preferenceKey, messageArguments, length, offset, target);
        try {
            if (marker != null) {
                marker.setAttribute(MESSAGE_ID_ATTRIBUTE_NAME, (Object)new Integer(messageId));
            }
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        return marker;
    }

    protected boolean shouldValidateJavaSources() {
        return false;
    }

    protected String getMessageBundleName() {
        return null;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new CompositeComponentPreferenceInfo());
    }

    public static class CompositeComponentPreferenceInfo
    implements IPreferenceInfo {
        public String getPreferencePageId() {
            return CompositeComponentValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return CompositeComponentValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.jsf";
        }
    }
}

