/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.browser.CSSBrowserEmptyImplementation;
import org.jboss.tools.jst.web.ui.internal.css.browser.CSSBrowserImplementation;
import org.jboss.tools.jst.web.ui.internal.css.browser.CSSBrowserInterface;

public class CSSBrowser
extends Composite
implements CSSBrowserInterface {
    private CSSBrowserInterface browser;

    private CSSBrowser(Composite parent, int style) {
        super(parent, style);
    }

    public static CSSBrowser createCSSBrowser(Composite parent, int style) {
        CSSBrowser cssBrowser = new CSSBrowser(parent, style);
        cssBrowser.setLayout((Layout)new GridLayout());
        Browser browser = WebUiPlugin.createBrowser(cssBrowser, 2048);
        if (browser != null) {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            browser.setLayoutData((Object)gridData);
            browser.pack();
            cssBrowser.setBrowser(new CSSBrowserImplementation(browser));
        } else {
            Label label = new Label((Composite)cssBrowser, 0x1000000);
            label.setText("Browser based preview not availabe," + System.getProperty("line.separator") + " see log for more details");
            label.setBounds(cssBrowser.getClientArea());
            cssBrowser.setBrowser(new CSSBrowserEmptyImplementation());
        }
        return cssBrowser;
    }

    public void setLayoutData(GridData layoutData) {
        super.setLayoutData((Object)layoutData);
    }

    @Override
    public boolean setFocus() {
        return this.getBrowser().setFocus();
    }

    @Override
    public void setText(String generateBrowserPage) {
        this.getBrowser().setText(generateBrowserPage);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.getBrowser().setEnabled(isEnabled);
    }

    @Override
    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.getBrowser().addMouseListener(mouseAdapter);
    }

    @Override
    public boolean isBrowserEvent(TypedEvent e) {
        return this.getBrowser().isBrowserEvent(e);
    }

    private CSSBrowserInterface getBrowser() {
        return this.browser;
    }

    private void setBrowser(CSSBrowserInterface browser) {
        this.browser = browser;
    }
}

