/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog;

import java.util.Map;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.widgets.Split;
import org.jboss.tools.jst.web.ui.internal.css.browser.CSSBrowser;
import org.jboss.tools.jst.web.ui.internal.css.dialog.StyleComposite;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.StyleAttributes;
import org.jboss.tools.jst.web.ui.internal.css.view.CSSPreviewPageCreator;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public abstract class AbstractCSSDialog
extends TitleAreaDialog {
    private CSSBrowser browser;
    private Text previewText;
    private String previewContent;
    private StyleAttributes styleAttributes;
    private StyleComposite styleComposite;
    private DataBindingContext bindingContext = new DataBindingContext();
    private AggregateValidationStatus aggregateStatus;
    private IStatus status = Status.OK_STATUS;
    public static final int DEFAULT_DIALOG_WIDTH = 500;
    public static final int DEFAULT_DIALOG_HEIGHT = 500;
    public static final int DEFAULT_BROWTHER_WEIGHT = 15;
    public static final int DEFAULT_CONTROLS_WEIGHT = 85;

    public AbstractCSSDialog(Shell shell) {
        super(shell);
        this.previewContent = JstUIMessages.DEFAULT_TEXT_FOR_BROWSER_PREVIEW;
        this.styleAttributes = new StyleAttributes();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ModelUIImages.getImage((String)ModelUIImages.WIZARD_DEFAULT));
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = (GridData)parentComposite.getLayoutData();
        gridData.heightHint = 500;
        gridData.widthHint = 500;
        this.createControlPane(parentComposite);
        return parentComposite;
    }

    public Composite createControlPane(Composite parent) {
        this.getStyleAttributes().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                AbstractCSSDialog.this.handleStyleChanged();
            }
        });
        this.aggregateStatus = new AggregateValidationStatus((IObservableCollection)this.getBindingContext().getValidationStatusProviders(), 2);
        this.aggregateStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractCSSDialog.this.handleStatusChanged((IStatus)event.diff.getNewValue());
            }
        });
        Split dialogContainer = new Split(parent, 512);
        this.createBrowserComposite((Composite)dialogContainer);
        this.createControlComposite((Composite)dialogContainer);
        dialogContainer.setWeights(new int[]{15, 85});
        dialogContainer.setLayoutData((Object)new GridData(4, 1, true, true));
        return dialogContainer;
    }

    protected Composite createControlComposite(Composite parent) {
        Composite controlsContainer = new Composite(parent, 0);
        controlsContainer.setLayout((Layout)new GridLayout());
        controlsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createExtensionComposite(controlsContainer);
        this.styleComposite = this.createStyleComposite(controlsContainer);
        return controlsContainer;
    }

    protected void createExtensionComposite(Composite parent) {
    }

    protected Composite createBrowserComposite(Composite parent) {
        final SashForm previewComposite = new SashForm(parent, 0);
        previewComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        previewComposite.setLayoutData((Object)gridData);
        this.browser = CSSBrowser.createCSSBrowser((Composite)previewComposite, 2048);
        this.browser.setText(this.generateBrowserPage());
        this.browser.setLayoutData(gridData);
        this.browser.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (AbstractCSSDialog.this.browser.isBrowserEvent((TypedEvent)e)) {
                    AbstractCSSDialog.this.browser.setEnabled(false);
                    previewComposite.setMaximizedControl((Control)AbstractCSSDialog.this.previewText);
                    AbstractCSSDialog.this.previewText.setFocus();
                }
            }
        });
        this.previewText = new Text((Composite)previewComposite, 256);
        this.previewText.setLayoutData((Object)gridData);
        this.previewText.setText(this.getPreviewContent());
        this.previewText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.widget == AbstractCSSDialog.this.previewText) {
                    String text = AbstractCSSDialog.this.previewText.getText();
                    if (text == null || text.equals("")) {
                        AbstractCSSDialog.this.setPreviewContent(JstUIMessages.DEFAULT_TEXT_FOR_BROWSER_PREVIEW);
                    } else {
                        AbstractCSSDialog.this.setPreviewContent(text);
                    }
                    AbstractCSSDialog.this.browser.setEnabled(true);
                    AbstractCSSDialog.this.browser.setText(AbstractCSSDialog.this.generateBrowserPage());
                    previewComposite.setMaximizedControl((Control)AbstractCSSDialog.this.browser);
                }
            }
        });
        previewComposite.setMaximizedControl((Control)this.browser);
        return previewComposite;
    }

    protected StyleComposite createStyleComposite(Composite parent) {
        return new StyleComposite(parent, this.getStyleAttributes(), this.getBindingContext());
    }

    protected void handleStyleChanged() {
        this.browser.setText(this.generateBrowserPage());
    }

    protected void handleStatusChanged(IStatus newStatus) {
        if (newStatus.isOK() && !this.status.isOK()) {
            this.setErrorMessage(null);
        } else if (newStatus.getSeverity() == 4) {
            this.setErrorMessage(newStatus.getMessage());
        }
        if (newStatus.getSeverity() != this.status.getSeverity()) {
            this.getButton(0).setEnabled(newStatus.isOK());
        }
        this.status = newStatus;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String generateBrowserPage() {
        StringBuffer style = new StringBuffer();
        for (Map.Entry<String, String> styleItem : this.getStyleAttributes().entrySet()) {
            style.append(String.valueOf(styleItem.getKey()) + ":" + styleItem.getValue() + ";");
        }
        return CSSPreviewPageCreator.createPreviewHtml(style.toString(), this.getPreviewContent());
    }

    public void releaseResources() {
        this.aggregateStatus.dispose();
    }

    public boolean close() {
        this.releaseResources();
        return super.close();
    }

    public StyleAttributes getStyleAttributes() {
        return this.styleAttributes;
    }

    public String getPreviewContent() {
        return this.previewContent;
    }

    public void setPreviewContent(String previewContent) {
        this.previewContent = previewContent;
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public StyleComposite getStyleComposite() {
        return this.styleComposite;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }
}

