/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.jst.web.ui.internal.css.dialog.AbstractCSSDialog;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSConstants;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.Util;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.outline.css.CSSStyleDialogInterface;

public class CSSStyleDialog
extends AbstractCSSDialog
implements CSSStyleDialogInterface {
    public CSSStyleDialog(Shell parentShell, String style) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400 | 0x10000);
        this.getStyleAttributes().setStyleProperties(this.parseStyle(style));
    }

    @Override
    public String getStyle() {
        return this.getStyleAttributes().getStyle();
    }

    protected Map<String, String> parseStyle(String styleString) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (styleString != null && styleString.length() > 0) {
            String[] styles;
            String[] stringArray = styles = styleString.split(";");
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String styleElement = stringArray[n2];
                String[] styleElementParts = styleElement.trim().split(":");
                if (styleElementParts != null && styleElementParts.length == 2 && Util.searchInElement(styleElementParts[0], CSSConstants.CSS_STYLES_MAP)) {
                    properties.put(styleElementParts[0], styleElementParts[1]);
                }
                ++n2;
            }
        }
        return properties;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JstUIMessages.CSS_STYLE_EDITOR_TITLE);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle(JstUIMessages.CSS_STYLE_EDITOR_TITLE);
        return super.createDialogArea(parent);
    }
}

