/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.FileExtensionFilter;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class ImageSelectionDialog
extends SelectionStatusDialog {
    static final String[][] fileExtensions = new String[][]{{"jpeg", "jpg", "jpe", "jfif"}, {"gif"}, {"bmp"}, {"tif", "tiff"}, {"png"}, {"ico"}};
    private Combo filterCombo;
    private Canvas canvas;
    private IFile file;
    private Text resolution;
    private Color emptyColor;
    private TreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private boolean fAllowMultiple = true;
    private boolean fDoubleClickSelects = true;
    private String fEmptyListMessage = WorkbenchMessages.ElementTreeSelectionDialog_nothing_available;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List<ViewerFilter> fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;

    public ImageSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.fAllowMultiple = allowMultiple;
    }

    public void setDoubleClickSelects(boolean doubleClickSelects) {
        this.fDoubleClickSelects = doubleClickSelects;
    }

    public void setSorter(ViewerSorter sorter) {
        this.fComparator = sorter;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void addFilter(String[] extention) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>(4);
        }
        this.fFilters.add(new FileExtensionFilter(extention));
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getResult());
                this.updateStatus(this.fCurrStatus);
            } else {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ImageSelectionDialog.this.access$superCreate();
                ImageSelectionDialog.this.fViewer.setSelection((ISelection)new StructuredSelection(ImageSelectionDialog.this.getInitialElementSelections()), true);
                ImageSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SelectionStatusDialog.applyDialogFont((Control)composite);
        Label messageLabel = this.createMessageArea(composite);
        new Label(composite, 0);
        TreeViewer treeViewer = this.createTreeViewer(composite);
        Composite comp = this.createPreview(composite);
        GridData browserData = new GridData(1808);
        browserData.widthHint = this.convertWidthInCharsToPixels(this.fWidth / 2);
        browserData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        browserData.minimumWidth = this.convertWidthInCharsToPixels(this.fWidth / 2);
        browserData.minimumHeight = this.convertHeightInCharsToPixels(this.fHeight);
        comp.setLayoutData((Object)browserData);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.filterCombo = new Combo(composite, 2056);
        this.filterCombo.setLayoutData((Object)new GridData(4, 2, false, false));
        this.filterCombo.add(JstUIMessages.ALL_FILES);
        this.filterCombo.add(JstUIMessages.ALL_IMAGE_FILES);
        int i = 0;
        while (i < fileExtensions.length) {
            String[] str = fileExtensions[i];
            StringBuffer buf = new StringBuffer();
            int j = 0;
            while (j < str.length) {
                buf.append("*." + str[j].toUpperCase() + "; ");
                ++j;
            }
            this.filterCombo.add(buf.toString());
            ++i;
        }
        this.filterCombo.select(0);
        this.filterCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageSelectionDialog.this.fViewer != null) {
                    ViewerFilter[] filters = ImageSelectionDialog.this.fViewer.getFilters();
                    if (filters != null) {
                        int i = 0;
                        while (i < filters.length) {
                            ImageSelectionDialog.this.fViewer.removeFilter(filters[i]);
                            ++i;
                        }
                    }
                    if (ImageSelectionDialog.this.filterCombo.getSelectionIndex() != 0) {
                        if (ImageSelectionDialog.this.filterCombo.getSelectionIndex() == 1) {
                            HashSet<String> s = new HashSet<String>();
                            int i = 0;
                            while (i < fileExtensions.length) {
                                String[] tmp = fileExtensions[i];
                                int j = 0;
                                while (j < tmp.length) {
                                    s.add(tmp[j]);
                                    ++j;
                                }
                                ++i;
                            }
                            String[] allExtensions = new String[s.size()];
                            s.toArray(allExtensions);
                            ImageSelectionDialog.this.fViewer.addFilter((ViewerFilter)new FileExtensionFilter(allExtensions));
                        } else {
                            ImageSelectionDialog.this.fViewer.addFilter((ViewerFilter)new FileExtensionFilter(fileExtensions[ImageSelectionDialog.this.filterCombo.getSelectionIndex() - 2]));
                        }
                    }
                    ImageSelectionDialog.this.fViewer.refresh();
                    if (ImageSelectionDialog.this.fViewer.getTree().getItemCount() <= 0) {
                        ImageSelectionDialog.this.fIsEmpty = true;
                    } else {
                        ImageSelectionDialog.this.fIsEmpty = false;
                    }
                    if (ImageSelectionDialog.this.fViewer.getTree().getSelectionCount() <= 0) {
                        ImageSelectionDialog.this.file = null;
                        ImageSelectionDialog.this.canvas.redraw();
                    }
                    ImageSelectionDialog.this.updateOKStatus();
                }
            }
        });
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
        }
        this.fValidator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Object selecObject;
                if (selection != null && selection.length == 1 && (selecObject = selection[0]) instanceof IFile) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.ui", 4, JstUIMessages.ImageSelectionDialog_InvalidImageFile, null);
            }
        };
        return composite;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 0x800 | (this.fAllowMultiple ? 2 : 4);
        this.fViewer = new TreeViewer(new Tree(parent, style));
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImageSelectionDialog.this.access$setResult(((IStructuredSelection)event.getSelection()).toList());
                ImageSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object obj = ImageSelectionDialog.this.getFirstResult();
                if (obj instanceof IFile) {
                    ImageSelectionDialog.this.file = (IFile)ImageSelectionDialog.this.getFirstResult();
                } else if (obj instanceof IFolder) {
                    ImageSelectionDialog.this.file = null;
                }
                ImageSelectionDialog.this.canvas.redraw();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter(this.fFilters.get(i));
                ++i;
            }
        }
        if (this.fDoubleClickSelects) {
            Tree tree = this.fViewer.getTree();
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ImageSelectionDialog.this.updateOKStatus();
                    if (ImageSelectionDialog.this.fCurrStatus.isOK()) {
                        ImageSelectionDialog.this.access$superButtonPressed(0);
                    }
                }
            });
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection;
                ImageSelectionDialog.this.updateOKStatus();
                if (!(ImageSelectionDialog.this.fDoubleClickSelects && ImageSelectionDialog.this.fCurrStatus.isOK() || !((selection = event.getSelection()) instanceof IStructuredSelection))) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ImageSelectionDialog.this.fViewer.getExpandedState(item)) {
                        ImageSelectionDialog.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        ImageSelectionDialog.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected void access$superButtonPressed(int id) {
        super.buttonPressed(id);
    }

    protected void access$setResult(List<Object> result) {
        super.setResult(result);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        if (this.getReturnCode() == 1) {
            this.setResult(null);
        }
    }

    private void access$superCreate() {
        super.create();
    }

    private Composite createPreview(Composite parent) {
        Object o;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2, 2, false, false));
        label.setText(JstUIMessages.IMAGE_PREVIEW);
        this.canvas = new Canvas(composite, 2048);
        GridData browserData = new GridData(1808);
        browserData.widthHint = this.convertWidthInCharsToPixels(this.fWidth / 2);
        browserData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        this.canvas.setLayoutData((Object)browserData);
        this.resolution = new Text(composite, 0x1000008);
        this.resolution.setLayoutData((Object)new GridData(4, 2, false, false));
        this.resolution.setVisible(false);
        this.emptyColor = this.canvas.getForeground();
        List list = this.getInitialElementSelections();
        if (!list.isEmpty() && (o = list.iterator().next()) instanceof IFile) {
            this.file = (IFile)o;
        }
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                block12: {
                    GC gc = new GC((Drawable)ImageSelectionDialog.this.canvas);
                    try {
                        gc.setForeground(ImageSelectionDialog.this.emptyColor);
                        gc.fillRectangle(1, 1, ((ImageSelectionDialog)ImageSelectionDialog.this).canvas.getSize().x - 2, ((ImageSelectionDialog)ImageSelectionDialog.this).canvas.getSize().y - 2);
                        ImageSelectionDialog.this.resolution.setVisible(false);
                        if (ImageSelectionDialog.this.file == null) break block12;
                        Cursor parentCursor = ImageSelectionDialog.this.getShell().getCursor();
                        Point previewPoint = new Point(0, 0);
                        Point labelPoint = ImageSelectionDialog.this.canvas.getSize();
                        FileInputStream stream = null;
                        try {
                            try {
                                ImageSelectionDialog.this.getShell().setCursor(Display.getCurrent().getSystemCursor(1));
                                stream = new FileInputStream(ImageSelectionDialog.this.file.getLocation().toOSString());
                                ImageData imageData = new ImageData((InputStream)stream);
                                ((InputStream)stream).close();
                                if (imageData != null) {
                                    Image image = new Image((Device)ImageSelectionDialog.this.getShell().getDisplay(), imageData);
                                    Point imagePoint = new Point(image.getBounds().width, image.getBounds().height);
                                    String imageInfo = String.valueOf(imagePoint.x) + " x " + imagePoint.y + " px";
                                    if (imagePoint.x > labelPoint.x || imagePoint.y > labelPoint.y) {
                                        float ratioImage = (float)imagePoint.x / (float)imagePoint.y;
                                        imageData = imagePoint.y > labelPoint.y && (float)labelPoint.y * ratioImage > (float)labelPoint.x || imagePoint.x > labelPoint.x && (float)labelPoint.x / ratioImage < (float)labelPoint.y ? imageData.scaledTo(labelPoint.x - 10, (int)((float)labelPoint.x / ratioImage)) : imageData.scaledTo((int)((float)labelPoint.y * ratioImage) - 10, labelPoint.y);
                                        image.dispose();
                                        image = new Image((Device)ImageSelectionDialog.this.getShell().getDisplay(), imageData);
                                        imagePoint.x = image.getBounds().width;
                                        imagePoint.y = image.getBounds().height;
                                    }
                                    previewPoint.x = labelPoint.x / 2 - imagePoint.x / 2;
                                    previewPoint.y = labelPoint.y / 2 - imagePoint.y / 2;
                                    gc.drawImage(image, previewPoint.x, previewPoint.y);
                                    ImageSelectionDialog.this.resolution.setVisible(true);
                                    ImageSelectionDialog.this.resolution.setText(imageInfo);
                                    image.dispose();
                                }
                            }
                            catch (IOException iOException) {
                                ImageSelectionDialog.this.getShell().setCursor(parentCursor);
                            }
                            catch (SWTException sWTException) {
                                ImageSelectionDialog.this.getShell().setCursor(parentCursor);
                            }
                        }
                        finally {
                            ImageSelectionDialog.this.getShell().setCursor(parentCursor);
                        }
                    }
                    finally {
                        gc.dispose();
                    }
                }
            }
        });
        return composite;
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fViewer, input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }
}

