/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLModelQueryCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlCompletionProposalComputer
extends AbstractXMLModelQueryCompletionProposalComputer {
    protected static final ICompletionProposal[] EMPTY_PROPOSAL_LIST = new ICompletionProposal[0];
    private static final KbQuery.Tag[] EMPTY_TAGS_W_ATTRIBUTES = new KbQuery.Tag[0];
    public static final String EL_DOLLAR_PREFIX = "${";
    public static final String EL_NUMBER_PREFIX = "#{";
    public static final String EL_SUFFIX = "}";
    public static final String[] EL_PREFIXES = new String[]{"${", "#{"};
    protected CompletionProposalInvocationContext fCurrentContext;
    protected ELContext fContext;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        this.fCurrentContext = context;
        this.fContext = this.createContext();
        IFile resource = this.fContext == null ? null : this.fContext.getResource();
        KbProject.checkKBBuilderInstalled((IResource)resource);
        return super.computeCompletionProposals(context, monitor);
    }

    protected abstract void addTagInsertionProposals(ContentAssistRequest var1, int var2, CompletionProposalInvocationContext var3);

    protected abstract void addAttributeValueProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract ELContext createContext();

    protected final ELContext createContext(String contextType) {
        IDocument document = this.getDocument();
        IFile file = PageContextFactory.getResource((IDocument)document);
        if (file == null) {
            return null;
        }
        return PageContextFactory.createPageContext((IDocument)document, (IFile)file, (String)contextType, (boolean)false);
    }

    protected abstract KbQuery createKbQuery(KbQuery.Type var1, String var2, String var3);

    protected abstract KbQuery createKbQuery(KbQuery.Type var1, String var2, String var3, String var4, String var5);

    Node findNodeForOffset(IDOMNode node, int offset) {
        int i;
        if (node == null) {
            return null;
        }
        if (!node.contains(offset)) {
            return null;
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            i = 0;
            while (children != null && i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if (child.contains(offset)) {
                    return this.findNodeForOffset(child, offset);
                }
                ++i;
            }
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            i = 0;
            while (attributes != null && i < attributes.getLength()) {
                IDOMNode attr = (IDOMNode)attributes.item(i);
                if (attr.contains(offset)) {
                    return attr;
                }
                ++i;
            }
        }
        return node;
    }

    Node findNodeForOffset(Node node, int offset) {
        return node instanceof IDOMNode ? this.findNodeForOffset((IDOMNode)node, offset) : null;
    }

    protected static int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length();
        }
        return cursorAdjustment;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            if (sModel != null) {
                IDOMDocument xmlDocument;
                IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
                if (xmlDocument != null) {
                    Node n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
                    Element currentElement = null;
                    if (n != null) {
                        if (n instanceof Element) {
                            currentElement = (Element)n;
                        } else if (n instanceof Attr) {
                            currentElement = ((Attr)n).getOwnerElement();
                        }
                        if (currentElement != null) {
                            NamedNodeMap nodeMap = currentElement.getAttributes();
                            int i = 0;
                            while (i < nodeMap.getLength()) {
                                Node attr = nodeMap.item(i);
                                String name = attr.getNodeName();
                                String value = attr.getNodeValue();
                                attributes.put(name, value == null ? "" : value);
                                ++i;
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return attributes;
    }

    public KbQuery.Tag[] getParentTagsWithAttributes(boolean includeThisTag) {
        ArrayList<KbQuery.Tag> parentTags = new ArrayList<KbQuery.Tag>();
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                KbQuery.Tag[] tagArray = EMPTY_TAGS_W_ATTRIBUTES;
                return tagArray;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                KbQuery.Tag[] tagArray = EMPTY_TAGS_W_ATTRIBUTES;
                return tagArray;
            }
            Node n = null;
            if (includeThisTag) {
                n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
            } else {
                IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
                if (sdFixedRegion == null) {
                    KbQuery.Tag[] tagArray = EMPTY_TAGS_W_ATTRIBUTES;
                    return tagArray;
                }
                n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            }
            if (n == null) {
                KbQuery.Tag[] tagArray = EMPTY_TAGS_W_ATTRIBUTES;
                return tagArray;
            }
            if (!(n instanceof Element)) {
                n = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
            } else if (!includeThisTag) {
                n = n.getParentNode();
            }
            while (n != null && n instanceof Element) {
                String tagName = this.getTagName(n);
                HashMap<String, String> attributes = new HashMap<String, String>();
                NamedNodeMap nodeMap = n.getAttributes();
                int i = 0;
                while (i < nodeMap.getLength()) {
                    Node attr = nodeMap.item(i);
                    String name = attr.getNodeName();
                    String value = attr.getNodeValue();
                    attributes.put(name, value == null ? "" : value);
                    ++i;
                }
                KbQuery.Tag newTag = new KbQuery.Tag(tagName, attributes);
                parentTags.add(0, newTag);
                n = n.getParentNode();
            }
            KbQuery.Tag[] tagArray = parentTags.toArray(new KbQuery.Tag[parentTags.size()]);
            return tagArray;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public String[] getParentTags(boolean includeThisTag) {
        KbQuery.Tag[] tags = this.getParentTagsWithAttributes(includeThisTag);
        String[] parentTags = new String[tags.length];
        int i = 0;
        while (i < parentTags.length) {
            parentTags[i] = tags[i].getName();
            ++i;
        }
        return parentTags;
    }

    protected String getTagName(Node tag) {
        return tag.getNodeName();
    }

    protected String getParent(boolean returnAttributeName, boolean returnThisElement) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return null;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = null;
            if (returnAttributeName) {
                n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return null;
            }
            n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            return n;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public String getTagPrefix() {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            String nodePrefix;
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return null;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return null;
            }
            Node n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            if (n == null) {
                return null;
            }
            if (!(n instanceof Element) && !(n instanceof Attr)) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null) {
                return null;
            }
            String string = nodePrefix = ((Element)n).getPrefix();
            return string;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public abstract String getTagUri();

    protected abstract String getUri(String var1);

    protected int getOffset() {
        return this.fCurrentContext.getInvocationOffset();
    }

    protected IDocument getDocument() {
        return this.fCurrentContext.getDocument();
    }

    protected IFile getResource() {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            if (sModel != null) {
                String baseLocation = sModel.getBaseLocation();
                IPath location = new Path(baseLocation).makeAbsolute();
                IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                return iFile;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return null;
    }

    protected ELContext getContext() {
        return this.fContext;
    }

    public IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        IStructuredDocumentRegion sdRegion = null;
        int lastOffset = pos;
        IStructuredDocument doc = (IStructuredDocument)this.getDocument();
        if (doc == null) {
            return null;
        }
        do {
            ITextRegion region;
            if ((sdRegion = doc.getRegionAtCharacterOffset(lastOffset)) == null || (region = sdRegion.getRegionAtCharacterOffset(lastOffset)) == null || region.getType() != "XML_TAG_OPEN" || sdRegion.getStartOffset(region) != lastOffset) continue;
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                sdRegion = null;
                continue;
            }
            ITextRegion previousRegion = sdRegion.getRegionAtCharacterOffset(lastOffset - 1);
            if (previousRegion == null || previousRegion == region || previousRegion.getTextLength() != previousRegion.getLength()) continue;
            sdRegion = null;
        } while (sdRegion == null && --lastOffset >= 0);
        return sdRegion;
    }

    protected ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        Node prevnode;
        if (domnode == null) {
            return null;
        }
        IStructuredDocumentRegion sdNormalRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.fCurrentContext.getViewer(), (int)documentPosition);
        IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdFixedRegion != null && !sdFixedRegion.equals(sdNormalRegion) && (prevnode = domnode.getParentNode()) != null) {
            domnode = prevnode;
        }
        return this.getSuperCompletionRegion(documentPosition, domnode);
    }

    private ITextRegion getSuperCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    protected ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion previousRegion;
        ITextRegion region = this.getSuperCompletionRegion(offset, sdRegion);
        if (region != null && region.getType() == "UNDEFINED" && (previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1)) != null && previousRegion != region && previousRegion.getTextLength() < previousRegion.getLength()) {
            region = previousRegion;
        }
        return region;
    }

    private ITextRegion getSuperCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    protected ContentAssistRequest computeCompletionProposals(String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode, CompletionProposalInvocationContext context) {
        ContentAssistRequest contentAssistRequest = super.computeCompletionProposals(matchString, completionRegion, treeNode, xmlnode, context);
        if (contentAssistRequest == null) {
            IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(context.getInvocationOffset());
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, treeNode.getParentNode(), sdRegion, completionRegion, context.getInvocationOffset(), 0, "");
        }
        String regionType = completionRegion.getType();
        if (xmlnode.getNodeType() == 1 || xmlnode.getNodeType() == 9) {
            if (regionType == "XML_EMPTY_TAG_CLOSE") {
                this.addAttributeNameProposals(contentAssistRequest, context);
            } else if (regionType == "XML_CONTENT" || regionType == "XML_CHAR_REFERENCE" || regionType == "XML_ENTITY_REFERENCE" || regionType == "XML_PE_REFERENCE" || regionType == "BLOCK_TEXT" || regionType == "XML_END_TAG_OPEN") {
                this.addTextELProposals(contentAssistRequest, context);
            }
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest newContentAssistRequest(Node node, Node possibleParent, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter) {
        return new ContentAssistRequest(node, possibleParent, documentRegion, completionRegion, begin, length, filter);
    }

    protected abstract void addTagNameProposals(ContentAssistRequest var1, int var2, CompletionProposalInvocationContext var3);

    protected abstract void addAttributeValueELProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addTextELProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    public String getDefaultELPrefix() {
        return EL_NUMBER_PREFIX;
    }

    protected boolean startsWithELBeginning(String text) {
        return text != null && (text.startsWith(EL_DOLLAR_PREFIX) || text.startsWith(EL_NUMBER_PREFIX));
    }

    protected boolean endsWithELBeginning(String text) {
        return text != null && text.endsWith(EL_SUFFIX);
    }
}

