/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model;

import java.util.List;
import java.util.Properties;
import org.eclipse.ui.IEditorInput;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.BundleNameElement;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ModelElement;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.XModelAttributeValueResource;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class BundlesNameResourceElement
extends XModelAttributeValueResource {
    public static String SUPPORTED_ID = "jsf.bundles";
    private BundleNameElement[] bundleNameElements;
    static String ADD_BUNDLE_ACTION = JstUIMessages.BundlesNameResourceElement_AddBundle;

    public BundlesNameResourceElement(IEditorInput editorInput, ModelElement parent) {
        super(editorInput, parent);
    }

    public BundlesNameResourceElement(IEditorInput editorInput, String name, ModelElement parent) {
        super(editorInput, name, parent);
    }

    @Override
    public ModelElement[] getChildren() {
        if (this.bundleNameElements != null) {
            return this.bundleNameElements;
        }
        if (!this.isReadyToUse()) {
            return EMPTY_LIST;
        }
        List sourceList = this.provider.getList(this.xModel, SUPPORTED_ID, "", null);
        this.bundleNameElements = new BundleNameElement[sourceList.size()];
        int i = 0;
        while (i < sourceList.size()) {
            String bundleName = (String)sourceList.get(i);
            this.bundleNameElements[i] = new BundleNameElement(bundleName, this);
            ++i;
        }
        return this.bundleNameElements;
    }

    @Override
    public String getName() {
        return "Resource Bundles";
    }

    @Override
    public String[] getActions() {
        return new String[]{ADD_BUNDLE_ACTION};
    }

    @Override
    public void action(String name, Properties properties) {
        if (ADD_BUNDLE_ACTION.equals(name)) {
            this.addBundle(properties);
        }
    }

    void addBundle(Properties properties) {
        XModelObject o = this.getXModel().getByPath("root:JSFProjects/Resource Bundles");
        if (o == null) {
            return;
        }
        XActionInvoker.invoke((String)"CreateActions.CreateFiles.CreateFileProperties", (XModelObject)o, (Properties)properties);
        XModelObject c = (XModelObject)properties.get("created");
        this.bundleNameElements = null;
        if (c == null) {
            return;
        }
        o.set("invalidate", "true");
        this.getChildren();
        String path = this.getBaseName(c);
        if (path == null) {
            return;
        }
        int i = 0;
        while (i < this.bundleNameElements.length) {
            String name = this.bundleNameElements[i].getName();
            if (name.equals(path)) {
                properties.put("select", this.bundleNameElements[i]);
            }
            ++i;
        }
    }

    private String getBaseName(XModelObject c) {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)c);
        if (path == null) {
            return null;
        }
        if (path.endsWith(".properties")) {
            path = path.substring(0, path.length() - ".properties".length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.replace('/', '.');
    }
}

