/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.AttributeValueResource;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ImageFileElement;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ImageFolderElement;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ModelElement;
import org.jboss.tools.jst.web.ui.internal.editor.support.kb.WTPKbImageFileResource;

public class ImageFileResourceElement
extends AttributeValueResource {
    private ModelElement[] children;
    protected WTPKbImageFileResource wtpKbResource;

    protected ImageFileResourceElement(String name, ModelElement parent) {
        super(name, parent);
    }

    public ImageFileResourceElement(IEditorInput editorInput, ModelElement parent) {
        super(parent);
        this.wtpKbResource = new WTPKbImageFileResource(editorInput);
        this.name = this.wtpKbResource.isReadyToUse() ? this.wtpKbResource.getWebRootResource().getName() : "";
    }

    @Override
    public void setParams(CustomProposalType.Param[] params) {
        super.setParams(params);
        if (params != null && params.length > 0 && this.wtpKbResource != null) {
            CustomProposalType.Param[] paramArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                CustomProposalType.Param p = paramArray[n2];
                this.wtpKbResource.setConstraint(p.getName(), p.getValue());
                ++n2;
            }
        }
    }

    @Override
    protected String getFullName() {
        return "/";
    }

    @Override
    public int compareValue(String value) {
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        String thisValue = this.getComparedValue();
        if (this.wtpKbResource != null && this.wtpKbResource.getPathAddition() != null && value.startsWith(this.wtpKbResource.getPathAddition())) {
            thisValue = String.valueOf(this.wtpKbResource.getPathAddition()) + thisValue;
        }
        if (value.equals(thisValue)) {
            return 0;
        }
        if (value.startsWith(thisValue) || thisValue.startsWith(value)) {
            return value.length() - thisValue.length();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ModelElement[] getChildren() {
        if (this.children == null && this.wtpKbResource.isReadyToUse()) {
            WTPKbImageFileResource.ImagePathDescriptor[] pathes = this.wtpKbResource.getImagesFilesPathes(this.getFullName());
            this.children = new ModelElement[pathes.length];
            int i = 0;
            while (i < pathes.length) {
                IResource resource = pathes[i].getResource();
                this.children[i] = resource instanceof IFolder ? new ImageFolderElement(resource.getName(), this, this.wtpKbResource) : new ImageFileElement(resource.getName(), this);
                ++i;
            }
        }
        if (this.children == null) {
            return new ModelElement[0];
        }
        return this.children;
    }
}

