/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.PositionSearcher;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditorPart;

public class JSPMultiPageSelectionProvider
extends MultiPageSelectionProvider {
    JSPMultiPageEditorPart multiPageEditor;
    boolean isFiringSelection = false;

    public JSPMultiPageSelectionProvider(JSPMultiPageEditorPart multiPageEditor) {
        super((MultiPageEditorPart)multiPageEditor);
        this.multiPageEditor = multiPageEditor;
    }

    public JSPMultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public void setSelection(ISelection selection) {
        if (!this.isAppropriateSelected(selection = this.convertObjectSelection(selection))) {
            return;
        }
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        try {
            super.setSelection(selection);
        }
        finally {
            this.isFiringSelection = false;
        }
    }

    private ISelection convertObjectSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof XModelObject) {
            XModelObject o = (XModelObject)((IStructuredSelection)selection).getFirstElement();
            XModelObject f = FileSystemsHelper.getFile((XModelObject)o);
            if (((JSPMultiPageEditor)this.multiPageEditor).getModelObject() == f) {
                String text = ((FileAnyImpl)f).getAsText();
                PositionSearcher searcher = new PositionSearcher();
                searcher.init(text, o, null);
                searcher.execute();
                int bp = searcher.getStartPosition();
                int ep = searcher.getEndPosition();
                if (bp >= 0 && ep >= bp) {
                    selection = new TextSelection(bp, ep - bp);
                }
            }
        }
        return selection;
    }

    private boolean isAppropriateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return true;
        }
        if (selection.isEmpty()) {
            return true;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        return o instanceof IndexedRegion;
    }

    public boolean isFiringSelection() {
        return this.isFiringSelection;
    }

    public void fireSelectionChanged(SelectionChangedEvent event, ListenerList listenerList) {
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        super.fireSelectionChanged(event);
        this.isFiringSelection = false;
    }

    public void firePostSelectionChanged(SelectionChangedEvent event, ListenerList listenerList) {
        if (this.isFiringSelection) {
            return;
        }
        this.isFiringSelection = true;
        super.firePostSelectionChanged(event);
        this.isFiringSelection = false;
    }
}

