/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.taglib.CustomTagLibManager;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.outline.CategoryDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ICategoryProvider;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPPropertySourceAdapter;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySetViewer;

public class CategoryProviderFactory {
    private static String POINT_ID = "org.jboss.tools.jst.web.ui.CategoryDescriptor";
    private static final CategoryProviderFactory instance = new CategoryProviderFactory();
    private List<CategoryDescriptor> knownDescriptors = new ArrayList<CategoryDescriptor>();

    public static CategoryProviderFactory getInstance() {
        return instance;
    }

    private CategoryProviderFactory() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IPropertySetViewer> propertySetViewerClass;
            String uri;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getAttribute("name");
            if (name == null) {
                WebUiPlugin.getDefault().logError("Attribute \"name\" should be defined in extension point " + element.getNamespaceIdentifier());
            }
            if ((uri = element.getAttribute("uri")) == null) {
                WebUiPlugin.getDefault().logError("Attribute \"uri\" should be defined in extension point " + element.getNamespaceIdentifier());
            }
            if ((propertySetViewerClass = CategoryProviderFactory.getPropertySetViewerClass(element)) == null) {
                WebUiPlugin.getDefault().logError("Attribute \"property-set-viewer-class\" should be defined in extension point " + element.getNamespaceIdentifier());
            }
            Class<? extends JSPPropertySourceAdapter.ICategoryFilter> categoryFilterClass = CategoryProviderFactory.getCategoryFilterClass(element);
            if (name != null && uri != null && propertySetViewerClass != null) {
                this.knownDescriptors.add(new CategoryDescriptor(name, uri, categoryFilterClass, propertySetViewerClass));
            }
            ++n2;
        }
    }

    private static Class<? extends JSPPropertySourceAdapter.ICategoryFilter> getCategoryFilterClass(IConfigurationElement element) {
        if (element.getAttribute("category-filter-class") != null) {
            try {
                Object o = element.createExecutableExtension("category-filter-class");
                if (o instanceof JSPPropertySourceAdapter.ICategoryFilter) {
                    return o.getClass();
                }
                WebUiPlugin.getDefault().logError("Category Filter " + element.getAttribute("category-filter-class") + " should implement ICategoryFilter.");
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private static Class<? extends IPropertySetViewer> getPropertySetViewerClass(IConfigurationElement element) {
        try {
            Object o = element.createExecutableExtension("property-set-viewer-class");
            if (o instanceof IPropertySetViewer) {
                return o.getClass();
            }
            WebUiPlugin.getDefault().logError("Property Set Viewer " + element.getAttribute("property-set-viewer-class") + " should implement IPropertySetViewer.");
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        return null;
    }

    public CategoryDescriptor[] getCategoryDescriptors(IPageContext context) {
        ArrayList<CategoryDescriptor> result = new ArrayList<CategoryDescriptor>();
        for (CategoryDescriptor d : this.knownDescriptors) {
            ICustomTagLibrary l = CategoryProviderFactory.findLibrary(d.getURI());
            if (l == null || l.getRecognizer() == null || !l.getRecognizer().shouldBeLoaded((ITagLibrary)l, (ELContext)context)) continue;
            result.add(d);
        }
        return result.toArray(new CategoryDescriptor[0]);
    }

    static ICustomTagLibrary findLibrary(String uri) {
        ICustomTagLibrary[] iCustomTagLibraryArray = CustomTagLibManager.getInstance().getLibraries();
        int n = iCustomTagLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomTagLibrary l = iCustomTagLibraryArray[n2];
            if (uri.equals(l.getURI())) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public ICategoryProvider[] getProviders(IDocument document, KbQuery kbQuery) {
        return new ICategoryProvider[0];
    }
}

