/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.selection.bar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.Splitter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SelectionHelper;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SourceSelection;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SourceSelectionBuilder;
import org.jboss.tools.jst.web.ui.internal.editor.selection.bar.ImageButton;
import org.jboss.tools.jst.web.ui.internal.editor.selection.bar.NodeListener;
import org.jboss.tools.jst.web.ui.internal.editor.selection.bar.SelectionBarUpdateJob;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectionBar
extends Composite {
    private static final int SEL_ITEM_RIGHT_MARGIN = 5;
    private boolean isBarVisible = false;
    private Splitter splitter;
    private ToolBar toolbar = null;
    private Composite realBar = null;
    private Composite emptyBar = null;
    private boolean resizeListenerAdded = false;
    private FormData toolbarData;
    private Menu dropDownMenu = null;
    private int itemCount = 0;
    private StructuredTextEditor textEditor;
    private Node currentSelectedNode = null;
    private Node currentLastNode = null;
    private State toggleSelBarState;
    private Command toggleSelBarCommand;
    private ICommandListener toggleSelBarCommandListener;
    private ISelectionChangedListener selectionChangedListener;
    private ImageButton arrowButton;
    private List<INodeNotifier> nodeNotifiers = new ArrayList<INodeNotifier>();
    private NodeListener nodeListener = new NodeListener(this);
    SelectionBarUpdateJob updateJob = null;

    public SelectionBar(StructuredTextEditor textEditor, Composite parent, int style) {
        super(parent, style);
        this.textEditor = textEditor;
        if (this.textEditor.getTextViewer() != null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionBar.this.runUpdateJob(true);
                }
            };
            this.textEditor.getTextViewer().addPostSelectionChangedListener(this.selectionChangedListener);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.toggleSelBarCommand = commandService.getCommand("org.jboss.tools.jst.web.ui.internal.editor.commands.showSelectionBar");
        this.toggleSelBarState = this.toggleSelBarCommand.getState("org.eclipse.ui.commands.toggleState");
        this.toggleSelBarCommandListener = new ICommandListener(){

            public void commandChanged(CommandEvent commandEvent) {
                SelectionBar.this.refreshVisibility();
            }
        };
        this.toggleSelBarCommand.addCommandListener(this.toggleSelBarCommandListener);
        this.setLayout((Layout)new FillLayout());
        this.createToolBarComposite();
        this.isBarVisible = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
        this.showOneOfRealOrEmptyBar(this.isBarVisible);
    }

    public Composite createToolBarComposite() {
        this.splitter = new Splitter((Composite)this, 0);
        this.emptyBar = new Composite((Composite)this.splitter, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point point = super.computeSize(wHint, hHint, changed);
                point.y = 1;
                return point;
            }
        };
        this.emptyBar.setLayoutData((Object)new GridData(768));
        this.realBar = new Composite((Composite)this.splitter, 0);
        this.realBar.setLayout((Layout)new FormLayout());
        Image closeImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                SelectionBar.this.setRealBarVisible(false);
                if (SelectionBar.this.toggleSelBarState != null) {
                    SelectionBar.this.toggleSelBarState.setValue((Object)false);
                }
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Selection Tag Bar", false);
            }
        };
        ImageButton closeButton = new ImageButton(this.realBar, closeImage, JstUIMessages.HIDE_SELECTION_BAR);
        closeButton.addSelectionListener(closeListener);
        FormData closeBarData = new FormData();
        closeBarData.right = new FormAttachment(100);
        closeBarData.top = new FormAttachment(0);
        Composite closeItemComposite = closeButton.getComposite();
        closeItemComposite.setLayoutData((Object)closeBarData);
        this.toolbar = new ToolBar(this.realBar, 0x800100);
        this.toolbarData = new FormData();
        this.toolbarData.left = new FormAttachment(0);
        this.toolbarData.right = new FormAttachment((Control)closeItemComposite, 0, 16384);
        this.toolbarData.top = new FormAttachment(0);
        this.toolbar.setLayoutData((Object)this.toolbarData);
        this.createArrowButton();
        return this.splitter;
    }

    public void setRealBarVisible(boolean visible) {
        if (visible != this.isBarVisible) {
            this.isBarVisible = visible;
            this.showOneOfRealOrEmptyBar(visible);
        }
    }

    public boolean isRealBarVisible() {
        return this.isBarVisible;
    }

    private void showOneOfRealOrEmptyBar(boolean realBarIsVisible) {
        this.splitter.setVisible((Control)this.realBar, realBarIsVisible);
        this.splitter.setVisible((Control)this.emptyBar, !realBarIsVisible);
        ToolItem tempItem = new ToolItem(this.toolbar, 4);
        tempItem.setText(" ");
        tempItem.setEnabled(false);
        this.getParent().layout(true, true);
        tempItem.dispose();
    }

    public void refreshVisibility() {
        JSPMultiPageEditor jspEditor;
        boolean visible = this.toggleSelBarState != null && WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
        IEditorPart editorPart = this.textEditor.getEditorPart();
        if (editorPart instanceof JSPMultiPageEditor && (jspEditor = (JSPMultiPageEditor)editorPart).getSelectedPageIndex() == jspEditor.getPreviewIndex()) {
            visible = false;
        }
        this.setRealBarVisible(visible);
    }

    public void updateNodes(boolean forceUpdate) {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.textEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection == null) {
            return;
        }
        Node node = selection.getStartNode();
        Attr attr = selection.getFocusAttribute();
        if (attr != null) {
            node = attr;
        }
        if (this.currentSelectedNode == node && !forceUpdate) {
            return;
        }
        boolean ancestorSelected = this.isAncestor(node, this.currentLastNode);
        if (ancestorSelected) {
            if (forceUpdate) {
                this.setSelBarItems(this.currentLastNode);
            } else {
                this.setNodeSelected(this.currentSelectedNode, false);
            }
        } else {
            this.setSelBarItems(node);
            this.currentLastNode = node;
        }
        this.setNodeSelected(node, true);
        this.currentSelectedNode = node;
    }

    private void setNodeSelected(Node node, boolean selected) {
        ToolItem item;
        ToolItem[] toolItemArray = this.toolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = toolItemArray[n2];
            if (item.getData() == node) {
                item.setSelection(selected);
                return;
            }
            ++n2;
        }
        if (this.dropDownMenu == null) {
            return;
        }
        toolItemArray = this.dropDownMenu.getItems();
        n = toolItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = toolItemArray[n2];
            if (item.getData() == node) {
                item.setSelection(selected);
                return;
            }
            ++n2;
        }
    }

    private void setSelBarItems(Node node) {
        this.removeNodeListenerFromAllNodes();
        this.cleanToolBar(this.toolbar);
        this.disposeDropDownMenu();
        int elementCounter = 0;
        boolean createDDLofAttributes = false;
        while (node != null && (node.getNodeType() == 1 || node.getNodeType() == 8 || node.getNodeType() == 2 || node.getNodeType() == 3 && node.getNodeValue().trim().length() > 0)) {
            this.addNodeListenerTo(node);
            if (this.dropDownMenu == null) {
                ToolItem item;
                NodeList children = node.getChildNodes();
                ArrayList<Node> list = new ArrayList<Node>();
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 1 || child.getNodeType() == 3 && child.getNodeValue().trim().length() > 0) {
                        list.add(child);
                    }
                    ++i;
                }
                if (elementCounter == 0 && list.size() == 0 || createDDLofAttributes) {
                    NamedNodeMap attrsMap = node.getAttributes();
                    if (attrsMap != null && attrsMap.getLength() > 0) {
                        list.clear();
                        int i2 = 0;
                        while (i2 < attrsMap.getLength()) {
                            list.add(attrsMap.item(i2));
                            ++i2;
                        }
                        item = new ToolItem(this.toolbar, 4, 1);
                        final DropdownSelectionListener dropdownListener = new DropdownSelectionListener(item, list);
                        item.addSelectionListener((SelectionListener)dropdownListener);
                        item.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                dropdownListener.disposeMenu();
                            }
                        });
                    } else {
                        item = new ToolItem(this.toolbar, 0x800020, 1);
                        item.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                SelectionBar.this.handleSelectionEvent(e);
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                SelectionBar.this.handleSelectionEvent(e);
                            }
                        });
                    }
                } else {
                    item = new ToolItem(this.toolbar, 4, 1);
                    final DropdownSelectionListener dropdownListener = new DropdownSelectionListener(item, list);
                    item.addSelectionListener((SelectionListener)dropdownListener);
                    item.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            dropdownListener.disposeMenu();
                        }
                    });
                }
                item.setData((Object)node);
                item.setText(node.getNodeName());
                if (!this.isItemShown(this.toolbar.getItem(elementCounter + 1))) {
                    item.dispose();
                    this.dropDownMenu = new Menu((Control)this.toolbar);
                }
            }
            if (this.dropDownMenu != null) {
                MenuItem menuItem = new MenuItem(this.dropDownMenu, 32, 0);
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SelectionBar.this.handleSelectionEvent(e);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        SelectionBar.this.handleSelectionEvent(e);
                    }
                });
                menuItem.setText(node.getNodeName());
                menuItem.setData((Object)node);
            }
            ++elementCounter;
            createDDLofAttributes = false;
            if (node instanceof Attr) {
                node = ((Attr)node).getOwnerElement();
                createDDLofAttributes = true;
                continue;
            }
            node = node.getParentNode();
        }
        this.itemCount = elementCounter;
        this.arrowButton.setEnabled(this.dropDownMenu != null);
        if (node != null && node.getNodeType() == 9) {
            this.addNodeListenerTo(node);
        }
        if (!this.resizeListenerAdded) {
            this.realBar.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    SelectionBar.this.runUpdateJob(true);
                }
            });
            this.resizeListenerAdded = true;
        }
    }

    private boolean isAncestor(Node potentialAncestor, Node node) {
        if (potentialAncestor == null || node == null) {
            return false;
        }
        Node curAncestor = node;
        while ((curAncestor = curAncestor.getParentNode()) != null) {
            if (potentialAncestor != curAncestor) continue;
            return true;
        }
        return false;
    }

    private void cleanToolBar(ToolBar toolBar) {
        ToolItem[] oldItems = toolBar.getItems();
        int i = 1;
        while (i < oldItems.length) {
            oldItems[i].dispose();
            ++i;
        }
    }

    private void createArrowButton() {
        Image hoverImage = WorkbenchImages.getImage((String)"IMG_LCL_RENDERED_VIEW_MENU");
        this.arrowButton = new ImageButton((Composite)this.toolbar, hoverImage, JstUIMessages.SelectionBar_MoreNodes);
        this.arrowButton.setEnabled(false);
        this.arrowButton.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = SelectionBar.this.arrowButton.getButtonBounds();
                Point point = SelectionBar.this.toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                SelectionBar.this.dropDownMenu.setLocation(point);
                SelectionBar.this.dropDownMenu.setVisible(true);
            }
        });
        ToolItem arrowItem = new ToolItem(this.toolbar, 2, 0);
        Composite arrowButtonComposite = this.arrowButton.getComposite();
        arrowItem.setControl((Control)arrowButtonComposite);
        arrowButtonComposite.pack();
        arrowItem.setWidth(arrowButtonComposite.getSize().x);
        FormData arrowToolBarData = new FormData();
        arrowToolBarData.left = new FormAttachment(0);
        arrowToolBarData.top = new FormAttachment(0);
        arrowButtonComposite.setLayoutData((Object)arrowToolBarData);
    }

    private boolean isItemShown(ToolItem toolItem) {
        ToolBar toolBar = toolItem.getParent();
        Rectangle toolItemBounds = toolItem.getBounds();
        toolItemBounds.width += 5;
        Rectangle intersection = toolBar.getBounds().intersection(toolItemBounds);
        return intersection.equals((Object)toolItemBounds);
    }

    private void addNodeListenerTo(Node node) {
        INodeNotifier notifier;
        if (node instanceof INodeNotifier && !this.nodeNotifiers.contains(notifier = (INodeNotifier)node)) {
            notifier.addAdapter((INodeAdapter)this.nodeListener);
            this.nodeNotifiers.add(notifier);
        }
    }

    private void removeNodeListenerFromAllNodes() {
        for (INodeNotifier notifier : this.nodeNotifiers) {
            notifier.removeAdapter((INodeAdapter)this.nodeListener);
        }
        this.nodeNotifiers.clear();
    }

    public void dispose() {
        this.removeNodeListenerFromAllNodes();
        this.toggleSelBarCommand.removeCommandListener(this.toggleSelBarCommandListener);
        if (this.textEditor.getTextViewer() != null) {
            this.textEditor.getTextViewer().removePostSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.splitter != null) {
            this.splitter.dispose();
            this.splitter = null;
        }
        this.disposeDropDownMenu();
        super.dispose();
    }

    private void disposeDropDownMenu() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public void handleSelectionEvent(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget instanceof ToolItem) {
            ((ToolItem)widget).setSelection(true);
        } else if (widget instanceof MenuItem) {
            ((MenuItem)widget).setSelection(true);
        }
        SelectionHelper.setSourceSelection(this.textEditor, (Node)widget.getData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public String toString() {
        StringBuffer st = new StringBuffer("CountItem: ");
        st.append(this.itemCount);
        st.append(" Parent Composite: " + this.realBar.getBounds().width);
        st.append(" Bar : " + this.toolbar.getBounds().width);
        return st.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpdateJob(boolean forceUpdate) {
        if (this.updateJob == null) {
            this.updateJob = new SelectionBarUpdateJob(this);
            if (forceUpdate) {
                this.updateJob.forceUpdate = true;
            }
            this.updateJob.schedule(100L);
        } else if (forceUpdate) {
            SelectionBar selectionBar = this;
            synchronized (selectionBar) {
                if (this.updateJob != null) {
                    this.updateJob.forceUpdate = true;
                }
            }
        }
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;
        private List<Node> children;
        private boolean shown = false;

        public DropdownSelectionListener(ToolItem dropdown, List<Node> children) {
            this.dropdown = dropdown;
            this.children = children;
        }

        public void disposeMenu() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public void add(Node node) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(node.getNodeName());
            menuItem.setData((Object)node);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelectionBar.this.handleSelectionEvent(event);
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                if (this.shown) {
                    if (this.menu != null) {
                        this.menu.setVisible(false);
                    }
                    this.shown = false;
                } else {
                    if (this.menu == null) {
                        this.menu = new Menu((Control)this.dropdown.getParent());
                        if (this.children != null && this.children.size() > 0) {
                            for (Node node : this.children) {
                                this.add(node);
                            }
                        }
                    }
                    this.menu.addMenuListener(new MenuListener(){

                        public void menuShown(MenuEvent e) {
                        }

                        public void menuHidden(MenuEvent e) {
                            DropdownSelectionListener.this.shown = false;
                        }
                    });
                    ToolItem item = (ToolItem)event.widget;
                    Rectangle rect = item.getBounds();
                    Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                    this.menu.setLocation(pt.x, pt.y + rect.height);
                    this.menu.setVisible(true);
                    this.shown = true;
                }
            } else {
                SelectionBar.this.handleSelectionEvent(event);
            }
        }
    }
}

