/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;

public class JSLibModel {
    Map<String, JSLib> libs = new TreeMap<String, JSLib>();
    static LibComparator libComparator = new LibComparator();

    public Collection<JSLib> getLibs() {
        return this.libs.values();
    }

    public JSLib[] getSortedLibs() {
        JSLib[] result = this.libs.values().toArray(new JSLib[0]);
        Arrays.sort(result, libComparator);
        return result;
    }

    public void addLib(JSLib lib) {
        this.libs.put(lib.getName(), lib);
    }

    public JSLib getLib(String name) {
        return this.libs.get(name);
    }

    public boolean removeLib(JSLib lib) {
        return this.libs.remove(lib.getName()) != null;
    }

    public JSLib getOrCreateLib(String name) {
        JSLib lib = this.getLib(name);
        if (lib == null) {
            lib = new JSLib();
            lib.setName(name);
            this.addLib(lib);
        }
        return lib;
    }

    public void applyWorkingCopy(JSLibModel copy, boolean applyRemoved) {
        if (applyRemoved) {
            Iterator<String> vs = this.libs.keySet().iterator();
            while (vs.hasNext()) {
                if (copy.getLib(vs.next()) != null) continue;
                vs.remove();
            }
        }
        for (JSLib vc : copy.getLibs()) {
            JSLib vo = this.getLib(vc.getName());
            if (vo == null) {
                this.addLib(vc);
                continue;
            }
            vo.applyWorkingCopy(vc, applyRemoved);
        }
    }

    public boolean equals(JSLibModel other) {
        if (this.libs.size() != other.libs.size()) {
            return false;
        }
        for (JSLib lib : this.libs.values()) {
            JSLib otherLib = other.libs.get(lib.getName());
            if (otherLib != null && lib.equals(otherLib)) continue;
            return false;
        }
        return true;
    }

    static class LibComparator
    implements Comparator<JSLib> {
        LibComparator() {
        }

        @Override
        public int compare(JSLib o1, JSLib o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

