/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.text.ext.hyperlink.ClassMethodHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSPBeanGetPropertyHyperlink
extends ClassMethodHyperlink {
    private static final String USEBEAN_TAGNAME = "jsp:useBean";
    private static final String ID_ATTRNAME = "id";
    private static final String NAME_ATTRNAME = "name";
    private static final String CLASS_ATTRNAME = "class";
    private static final String TYPE_ATTRNAME = "type";
    protected static final String GET_METHOD_PREFIX = "get";
    protected static final String SET_METHOD_PREFIX = "set";

    protected String getMethodPrefix() {
        return GET_METHOD_PREFIX;
    }

    private String getMethodName(String propertyName) {
        String name = propertyName.trim();
        name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return String.valueOf(this.getMethodPrefix()) + name;
    }

    protected String getClassName(IRegion region) {
        return null;
    }

    protected String getMethodName(IRegion region) {
        return null;
    }

    protected void doHyperlink(IRegion region) {
        try {
            String beanID = this.getBeanId(region);
            String propertyName = this.getPropertyName(region);
            Element elementByID = this.findElementByIDBackward(beanID, region.getOffset(), USEBEAN_TAGNAME);
            String className = this.getAttributeValue(elementByID, CLASS_ATTRNAME);
            String typeName = this.getAttributeValue(elementByID, TYPE_ATTRNAME);
            IJavaElement beanMethod = null;
            if (className != null && className.trim().length() > 0) {
                beanMethod = this.searchForClassMethod(className, this.getMethodName(propertyName));
            }
            if (beanMethod == null && typeName != null && typeName.trim().length() > 0) {
                beanMethod = this.searchForClassMethod(typeName, this.getMethodName(propertyName));
            }
            if (beanMethod != null) {
                IEditorPart part = JavaUI.openInEditor(beanMethod);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)beanMethod);
                } else {
                    this.openFileFailed();
                }
            } else {
                this.openFileFailed();
            }
        }
        catch (CoreException x) {
            this.openFileFailed();
        }
    }

    private Element findElementByIDBackward(String id, int endOffset, String tagname) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)endOffset);
            if (n == null) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            Element element = null;
            Node parent = n;
            while (parent != null && element == null) {
                element = this.findElementByIDBackward(xmlDocument.getChildNodes(), id, endOffset, tagname);
                parent = parent.getParentNode();
            }
            Element element2 = element;
            return element2;
        }
        finally {
            smw.dispose();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element findElementByIDBackward(NodeList list, String id, int endOffset, String tagName) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            block13: {
                int i;
                block12: {
                    smw.init(this.getDocument());
                    Document xmlDocument = smw.getDocument();
                    if (xmlDocument == null) {
                        return null;
                    }
                    i = list.getLength() - 1;
                    if (!true) break block12;
                    if (list == null) return null;
                    if (i < 0) break block13;
                }
                do {
                    Element element;
                    int start;
                    if (list.item(i) instanceof Element && (start = Utils.getValueStart((Node)(element = (Element)list.item(i)))) >= 0 && start < endOffset) {
                        Element child;
                        String val;
                        Attr idAttr;
                        String elementName = element.getNodeName();
                        if (tagName.equals(elementName) && (idAttr = element.getAttributeNode(ID_ATTRNAME)) != null && id.equals(val = Utils.trimQuotes((String)idAttr.getNodeValue()))) {
                            Element element2 = element;
                            return element2;
                        }
                        if (element.hasChildNodes() && (child = this.findElementByIDBackward(element.getChildNodes(), id, endOffset, tagName)) != null) {
                            Element element3 = child;
                            return element3;
                        }
                    }
                    --i;
                    if (list == null) return null;
                } while (i >= 0);
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    String getPropertyName(IRegion region) {
        try {
            return Utils.trimQuotes((String)this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            return null;
        }
    }

    private String getBeanId(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            String string = this.getAttributeValue(node, NAME_ATTRNAME);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String propertyName = this.getPropertyName(this.getHyperlinkRegion());
        if (propertyName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.Getter);
        }
        return MessageFormat.format(Messages.OpenGetterOrSetterForProperty, Messages.Getter, propertyName);
    }
}

