/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.preferences.DecoratorPreferencesListener;
import org.jboss.tools.common.model.ui.views.navigator.FilteredTreesCache;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

public class XContentProvider
implements ITreeContentProvider {
    protected Viewer viewer = null;
    protected TreeViewerModelListenerImpl listener = this.createListener();
    protected XModelTreeListenerSWTASync syncListener = new XModelTreeListenerSWTASync((XModelTreeListener)this.listener);
    DecoratorPreferencesListener decoratorListener = null;

    protected TreeViewerModelListenerImpl createListener() {
        return new TreeViewerModelListenerImpl();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof XModelObject) {
            XModelObject o = (XModelObject)parentElement;
            XFilteredTree filteredTree = this.getFilteredTree(parentElement);
            if (filteredTree != null) {
                return filteredTree.getChildren(o);
            }
            return o.getChildrenForSave();
        }
        if (parentElement instanceof IFile) {
            IPath p;
            IFile f = (IFile)parentElement;
            if (!f.isSynchronized(0) && (p = f.getLocation()) != null && !p.toFile().isFile()) {
                return null;
            }
            if (!f.isAccessible()) {
                return null;
            }
            XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)f);
            XFilteredTree filteredTree = this.getFilteredTree(o);
            if (filteredTree != null) {
                return filteredTree.getChildren(o);
            }
            if (o == null && (o = EclipseResourceUtil.createObjectForResource((IResource)f)) != null) {
                FilteredTreesCache.getInstance().addListener((XModelTreeListener)this.syncListener, o.getModel());
            }
            return this.getChildren(o);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof XModelObject) {
            XModelObject o = (XModelObject)element;
            XModelObject p = o.getParent();
            if (p != null && p.getFileType() == 1) {
                return EclipseResourceUtil.getResource((XModelObject)p);
            }
            return p;
        }
        if (element instanceof IResource) {
            IResource r = (IResource)element;
            return r.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        IFile f;
        if (element instanceof IFile && (element = EclipseResourceUtil.createObjectForResource((IResource)(f = (IFile)element))) == null) {
            return false;
        }
        if (element instanceof XModelObject) {
            XModelObject o = (XModelObject)element;
            XFilteredTree filteredTree = this.getFilteredTree(o);
            if (filteredTree != null) {
                return filteredTree.hasChildren(o);
            }
            return o.hasChildren();
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.viewer = null;
        if (this.syncListener != null) {
            FilteredTreesCache.getInstance().removeListener((XModelTreeListener)this.syncListener);
            this.syncListener = null;
            this.listener = null;
        }
        if (this.decoratorListener != null) {
            this.decoratorListener.dispose();
            this.decoratorListener = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.listener != null && viewer instanceof TreeViewer) {
            this.listener.setViewer((TreeViewer)viewer);
        }
        if (viewer instanceof StructuredViewer) {
            if (this.decoratorListener == null) {
                this.decoratorListener = new DecoratorPreferencesListener();
                this.decoratorListener.init();
            }
            this.decoratorListener.setViewer((StructuredViewer)viewer);
        }
    }

    protected XFilteredTree getFilteredTree(Object object) {
        XFilteredTree result = null;
        if (result == null && object instanceof XModelObject) {
            XModel model = ((XModelObject)object).getModel();
            String n = this.getFilteredTreeName(model);
            result = FilteredTreesCache.getInstance().getFilteredTree(n, model);
            if (result == null) {
                return null;
            }
            if (result.getRoot() == null) {
                result = null;
            } else {
                FilteredTreesCache.getInstance().addListener((XModelTreeListener)this.syncListener, model);
            }
        }
        return result;
    }

    protected String getFilteredTreeName(XModel model) {
        String nature = model.getProperties().getProperty("nature");
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)((IProject)model.getProperties().get("project")));
        if (nature != null && n != null && !n.getID().equals(nature)) {
            nature = n.getID();
            model.getProperties().setProperty("nature", nature);
        }
        if (nature != null && nature.indexOf("jsf") >= 0) {
            return "JSFProjects";
        }
        return null;
    }
}

