/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewAudioWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.SRCUtil;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;

public class NewAudioWizard
extends NewHTMLWidgetWizard<NewAudioWizardPage>
implements JQueryConstants {
    static String prefixId = "audio-";

    public NewAudioWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.AUDIO_IMAGE));
    }

    @Override
    protected NewAudioWizardPage createPage() {
        return new NewAudioWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        this.addContent(parent, false);
    }

    protected void addContent(IElementGenerator.ElementNode parent, boolean forBrowser) {
        IElementGenerator.ElementNode video = parent.addChild("audio", null);
        this.addID(prefixId, video);
        int i = 0;
        while (i < ((NewAudioWizardPage)this.page).items.getNumber()) {
            String src = ((NewAudioWizardPage)this.page).items.getSrc(i);
            if (forBrowser) {
                src = SRCUtil.getAbsoluteSrc(this.getFile(), src);
            }
            IElementGenerator.ElementNode source = video.addChild("source", null);
            source.addAttribute("src", src);
            String type = ((NewAudioWizardPage)this.page).items.getType(i);
            if (type.length() > 0) {
                source.addAttribute("type", type);
            }
            ++i;
        }
        if (this.isTrue("autoplay")) {
            video.addAttribute("autoplay", "autoplay");
        } else if (!"auto".equals(((NewAudioWizardPage)this.page).getEditorValue("preload"))) {
            this.addAttributeIfNotEmpty(video, "preload", "preload");
        }
        if (this.isTrue("controls")) {
            video.addAttribute("controls", "controls");
        }
        if (this.isTrue("loop")) {
            video.addAttribute("loop", "loop");
        }
        if (this.isTrue("muted")) {
            video.addAttribute("muted", "muted");
        }
    }

    @Override
    public String getTextForBrowser() {
        IElementGenerator.ElementNode html = new IElementGenerator.ElementNode("html", false);
        IElementGenerator.ElementNode body = html.addChild("body");
        this.createBodyForBrowser(body);
        IElementGenerator.NodeWriter w = new IElementGenerator.NodeWriter(false);
        html.flush(w, 0);
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>").append("\n").append(w.getText());
        return sb.toString();
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode div = body.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        div.addAttribute("align", "center");
        this.addContent(div, true);
    }
}

