/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewFormButtonWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class NewFormButtonWizard
extends NewJQueryWidgetWizard<NewFormButtonWizardPage>
implements JQueryConstants {
    public NewFormButtonWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.FORM_BUTTON_IMAGE));
    }

    @Override
    protected NewFormButtonWizardPage createPage() {
        return new NewFormButtonWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String value = ((NewFormButtonWizardPage)this.page).getEditorValue("value");
        if (value.length() == 0) {
            String type = ((NewFormButtonWizardPage)this.page).getEditorValue("type");
            if ("button".equals(type)) {
                value = "Input";
            } else if ("reset".equals(type)) {
                value = WizardMessages.buttonTypeResetLabel;
            } else if ("submit".equals(type)) {
                value = WizardMessages.buttonTypeSubmitLabel;
            }
        }
        if (this.getVersion() == JQueryMobileVersion.JQM_1_3) {
            this.addContent13(parent, value);
        } else {
            this.addContent14(parent, value);
        }
    }

    private void addContent13(IElementGenerator.ElementNode parent, String value) {
        String themeValue;
        IElementGenerator.ElementNode a = parent.addChild("input");
        this.addAttributeIfNotEmpty(a, "type", "type");
        a.addAttribute("value", value);
        if (this.isTrue("disabled")) {
            a.addAttribute("disabled", "disabled");
        }
        this.addID("button-", a);
        String icon = ((NewFormButtonWizardPage)this.page).getEditorValue("data-icon");
        if (icon.length() > 0) {
            a.addAttribute("data-icon", icon);
        }
        if ("true".equals(((NewFormButtonWizardPage)this.page).getEditorValue("icon-only"))) {
            a.addAttribute("data-iconpos", "notext");
        } else {
            String iconpos = ((NewFormButtonWizardPage)this.page).getEditorValue("data-iconpos");
            if (iconpos.length() > 0) {
                a.addAttribute("data-iconpos", iconpos);
            }
        }
        if (this.isMini()) {
            a.addAttribute("data-mini", "true");
        }
        if (this.isTrue("data-inline")) {
            a.addAttribute("data-inline", "true");
        }
        if (!this.isTrue("data-corners")) {
            a.addAttribute("data-corners", "false");
        }
        if ((themeValue = ((NewFormButtonWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            a.addAttribute("data-theme", themeValue);
        }
    }

    private void addContent14(IElementGenerator.ElementNode parent, String value) {
        String themeValue;
        IElementGenerator.ElementNode div = parent.addChild("div");
        div.addTextChild(value);
        IElementGenerator.ElementNode a = div.addChild("input");
        a.addAttribute("data-enhanced", "true");
        this.addAttributeIfNotEmpty(a, "type", "type");
        a.addAttribute("value", value);
        this.addID("button-", a);
        StringBuilder cls = new StringBuilder();
        cls.append("ui-input-btn").append(' ').append("ui-btn");
        String icon = ((NewFormButtonWizardPage)this.page).getEditorValue("data-icon");
        if (icon.length() > 0) {
            cls.append(' ').append("ui-icon-" + icon);
        }
        if (this.isTrue("icon-only")) {
            cls.append(' ').append("ui-btn-icon-notext");
        } else if (icon.length() > 0) {
            String iconpos = ((NewFormButtonWizardPage)this.page).getEditorValue("data-iconpos");
            if (iconpos.length() == 0) {
                iconpos = "left";
            }
            cls.append(' ').append("ui-btn-icon-" + iconpos);
        }
        if (this.isMini()) {
            cls.append(' ').append("ui-mini");
        }
        if (this.isTrue("data-inline")) {
            cls.append(' ').append("ui-btn-inline");
        }
        if (this.isTrue("data-corners")) {
            cls.append(' ').append("ui-corner-all");
        }
        if (this.isTrue("disabled")) {
            cls.append(' ').append("ui-state-disabled");
        }
        if ((themeValue = ((NewFormButtonWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            cls.append(' ').append("ui-btn-" + themeValue);
        }
        div.addAttribute("class", cls.toString());
    }

    public static <P extends AbstractNewHTMLWidgetWizardPage> void applyAction(P page, IElementGenerator.ElementNode a) {
        String action = page.getEditorValue("action");
        if (WizardMessages.actionDialogLabel.equals(action)) {
            a.addAttribute("data-rel", "dialog");
        } else if (WizardMessages.actionPopupLabel.equals(action)) {
            a.addAttribute("data-rel", "popup");
        } else if (WizardMessages.actionBackLabel.equals(action)) {
            a.addAttribute("data-rel", "back");
        } else if (WizardMessages.actionCloseLabel.equals(action)) {
            a.addAttribute("data-rel", "close");
        } else if (WizardMessages.actionExternalLabel.equals(action)) {
            a.addAttribute("data-rel", "external");
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

