/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewTextInputWizardPage;

public class NewTextInputWizard
extends NewJQueryWidgetWizard<NewTextInputWizardPage>
implements JQueryConstants {
    public NewTextInputWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.TEXT_INPUT_IMAGE));
    }

    @Override
    protected NewTextInputWizardPage createPage() {
        return new NewTextInputWizardPage();
    }

    protected boolean isRange() {
        return this.isTrue("range");
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String themeValue;
        if (this.isLayoutHorizontal()) {
            IElementGenerator.ElementNode div = parent.addChild("div");
            if (this.getVersion() == JQueryMobileVersion.JQM_1_3) {
                div.addAttribute("data-role", "fieldcontain");
            } else {
                div.addAttribute("class", "ui-field-contain");
            }
            parent = div;
        }
        String type = ((NewTextInputWizardPage)this.page).getEditorValue("text-type");
        boolean isTextArea = "textarea".equals(type);
        String id = this.getID(String.valueOf(type) + "-");
        IElementGenerator.ElementNode label = parent.addChild("label", ((NewTextInputWizardPage)this.page).getEditorValue("label"));
        IElementGenerator.ElementNode input = isTextArea ? parent.addChild("textarea", ((NewTextInputWizardPage)this.page).getEditorValue("value")) : parent.addChild("input");
        label.addAttribute("for", id);
        input.addAttribute("name", id);
        input.addAttribute("id", id);
        if (this.isTrue("hide-label")) {
            if (this.isLayoutHorizontal()) {
                parent.addAttribute("class", "ui-hide-label");
            } else {
                label.addAttribute("class", "ui-hidden-accessible");
            }
        }
        if (this.isTrue("data-clear-btn")) {
            input.addAttribute("data-clear-btn", "true");
        }
        if (this.isMini()) {
            input.addAttribute("data-mini", "true");
        }
        if (this.isTrue("disabled")) {
            input.addAttribute("disabled", "disabled");
        }
        if (!"textarea".equals(type)) {
            input.addAttribute("value", ((NewTextInputWizardPage)this.page).getEditorValue("value"));
        }
        this.addAttributeIfNotEmpty(input, "placeholder", "placeholder");
        if ("number".equals(type)) {
            this.addAttributeIfNotEmpty(input, "min", "min");
            this.addAttributeIfNotEmpty(input, "max", "max");
            this.addAttributeIfNotEmpty(input, "step", "step");
        }
        this.addAttributeIfNotEmpty(input, "pattern", "pattern");
        this.addAttributeIfNotEmpty(input, "maxlength", "maxlength");
        if (this.isTrue("autofocus")) {
            input.addAttribute("autofocus", "true");
        }
        if (this.isTrue("required")) {
            input.addAttribute("required", "true");
        }
        if ((themeValue = ((NewTextInputWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            input.addAttribute("data-theme", themeValue);
        }
        if (!"textarea".equals(type)) {
            input.addAttribute("type", type);
        } else {
            input.addAttribute("cols", "40");
            input.addAttribute("rows", "8");
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

