/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class CompoundDropTargetListener
extends DropTargetAdapter {
    private ArrayList<DropTargetListener> listeners = new ArrayList();
    private DropTargetListener activeListener = null;

    public void add(DropTargetListener listener) {
        this.listeners.add(listener);
    }

    public void remove(DropTargetListener listener) {
        this.listeners.remove(listener);
    }

    public void dragEnter(DropTargetEvent event) {
        int initialDetail = event.detail;
        this.activeListener = null;
        for (DropTargetListener listener : this.listeners) {
            listener.dragEnter(event);
            if (event.detail != 0) {
                this.activeListener = listener;
                return;
            }
            event.detail = initialDetail;
        }
        event.detail = 0;
    }

    public void drop(DropTargetEvent event) {
        if (this.activeListener != null) {
            this.activeListener.drop(event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (this.activeListener != null) {
            this.activeListener.dragOver(event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.activeListener != null) {
            this.activeListener.dragLeave(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.activeListener != null) {
            this.activeListener.dragOperationChanged(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.activeListener != null) {
            this.activeListener.dropAccept(event);
        }
    }
}

