/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewTextInputWizardPage;

public class NewTextInputWizard
extends NewHTMLWidgetWizard<NewTextInputWizardPage>
implements HTMLConstants {
    static String prefix = "input-";

    public NewTextInputWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.TEXT_INPUT_IMAGE));
    }

    @Override
    protected NewTextInputWizardPage createPage() {
        return new NewTextInputWizardPage();
    }

    String getTextInputID() {
        return this.getID(prefix);
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String type = ((NewTextInputWizardPage)this.page).getEditorValue("text-type");
        boolean isTextArea = "textarea".equals(type);
        String id = this.getID(prefix);
        String labelText = ((NewTextInputWizardPage)this.page).getEditorValue("label");
        if (labelText.length() > 0) {
            IElementGenerator.ElementNode label = parent.addChild("label", ((NewTextInputWizardPage)this.page).getEditorValue("label"));
            label.addAttribute("for", id);
        }
        IElementGenerator.ElementNode input = isTextArea ? parent.addChild("textarea", ((NewTextInputWizardPage)this.page).getEditorValue("value")) : parent.addChild("input");
        input.addAttribute("id", id);
        this.addAttributeIfNotEmpty(input, "name", "name");
        if (this.isTrue("disabled")) {
            input.addAttribute("disabled", "disabled");
        }
        if (!"textarea".equals(type)) {
            this.addAttributeIfNotEmpty(input, "value", "value");
        }
        this.addAttributeIfNotEmpty(input, "placeholder", "placeholder");
        if ("number".equals(type)) {
            this.addAttributeIfNotEmpty(input, "min", "min");
            this.addAttributeIfNotEmpty(input, "max", "max");
            this.addAttributeIfNotEmpty(input, "step", "step");
        }
        this.addAttributeIfNotEmpty(input, "pattern", "pattern");
        this.addAttributeIfNotEmpty(input, "maxlength", "maxlength");
        if (this.isTrue("autofocus")) {
            input.addAttribute("autofocus", "true");
        }
        if (this.isTrue("required")) {
            input.addAttribute("required", "true");
        }
        if (!"textarea".equals(type)) {
            input.addAttribute("type", type);
        } else {
            input.addAttribute("cols", "40");
            input.addAttribute("rows", "8");
        }
        this.addAttributeIfNotEmpty(input, "list", "list");
        IElementGenerator.ElementNode datalistNode = ((NewTextInputWizardPage)this.page).getDatalistNode();
        if (datalistNode != null) {
            parent.getChildren().add(datalistNode);
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

